/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.gen.BusinessMethodGenerator;
import com.caucho.ejb.gen.StatelessCreateMethod;
import com.caucho.ejb.gen.StatelessGenerator;
import com.caucho.ejb.gen.StatelessView;
import com.caucho.ejb.gen.View;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.lang.reflect.Method;

public abstract class StatelessHomeView
extends StatelessView {
    private static final L10N L = new L10N(StatelessHomeView.class);

    public StatelessHomeView(StatelessGenerator bean, ApiClass api) {
        super(bean, api);
    }

    protected abstract String getViewClassName();

    public void generateCreateProvider(JavaWriter out, String var) throws IOException {
        out.println();
        out.println("if (" + var + " == " + this.getApi().getName() + ".class)");
        out.println("  return _localHome;");
    }

    public void generate(JavaWriter out) throws IOException {
        out.println();
        out.println("public static class " + this.getViewClassName());
        out.println("  extends StatelessHome");
        out.println("  implements StatelessProvider, " + this.getApi().getName());
        out.println("{");
        out.pushDepth();
        this.generateClassContent(out);
        out.popDepth();
        out.println("}");
    }

    protected void generateClassContent(JavaWriter out) throws IOException {
        out.println("private " + this.getContextClassName() + " _context;");
        out.println("private StatelessServer _server;");
        out.println();
        out.println(this.getViewClassName() + "(" + this.getContextClassName() + " context)");
        out.println("{");
        out.pushDepth();
        this.generateSuper(out, "context.getStatelessServer()");
        out.println("_context = context;");
        out.println("_server = context.getStatelessServer();");
        this.generateBusinessConstructor(out);
        out.popDepth();
        out.println("}");
        out.println();
        out.println("public Object __caucho_createNew(ConfigContext env)");
        out.println("{");
        out.println("  return this;");
        out.println("}");
        out.println();
        out.println("public StatelessServer getStatelessServer()");
        out.println("{");
        out.println("  return _server;");
        out.println("}");
        out.println();
        out.println();
        out.println("public Object __caucho_get()");
        out.println("{");
        out.println("  return this;");
        out.println("}");
        out.println();
        this.generateBusinessMethods(out);
    }

    protected BusinessMethodGenerator createMethod(ApiMethod apiMethod, int index) {
        if (apiMethod.getName().equals("create")) {
            ApiMethod implMethod = this.getEjbClass().getMethod("ejbCreate", apiMethod.getParameterTypes());
            View localView = this.getStatelessBean().getView(apiMethod.getReturnType());
            if (localView == null) {
                throw ConfigException.create((Method)apiMethod.getMethod(), (String)L.l("'{0}' is an unknown object interface", (Object)apiMethod.getReturnType()));
            }
            return new StatelessCreateMethod(this.getStatelessBean(), this, localView, apiMethod, implMethod, index);
        }
        return super.createMethod(apiMethod, index);
    }

    protected ApiMethod findImplMethod(ApiMethod apiMethod) {
        if (apiMethod.getName().equals("create")) {
            return this.getEjbClass().getMethod("ejbCreate", apiMethod.getParameterTypes());
        }
        return super.findImplMethod(apiMethod);
    }

    protected void generateSuper(JavaWriter out, String serverVar) throws IOException {
        out.println("super(" + serverVar + ");");
    }

    protected void generateExtends(JavaWriter out) throws IOException {
        out.println("  extends StatelessHome");
    }
}

