/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.gen.BusinessMethodGenerator;
import com.caucho.ejb.gen.StatelessView;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.ejb.TransactionAttributeType;

public class StatelessLocalMethod
extends BusinessMethodGenerator {
    private ApiClass _ejbClass;
    private String _beanClassName;

    public StatelessLocalMethod(ApiClass ejbClass, String beanClassName, StatelessView view, ApiMethod apiMethod, Method implMethod, int index) {
        super(view, apiMethod, implMethod, index);
        this._beanClassName = beanClassName;
        this._ejbClass = ejbClass;
    }

    public void introspect(Method apiMethod, Method implMethod) {
        this.getXa().setTransactionType(TransactionAttributeType.REQUIRED);
        super.introspect(apiMethod, implMethod);
    }

    public boolean isEnhanced() {
        return true;
    }

    protected void generatePreCall(JavaWriter out) throws IOException {
        out.println("Thread thread = Thread.currentThread();");
        out.println("ClassLoader oldLoader = thread.getContextClassLoader();");
        out.println();
        out.println(this._beanClassName + " bean = _ejb_begin();");
        out.println("boolean isValid = false;");
        out.println();
        out.println("try {");
        out.pushDepth();
        out.println("thread.setContextClassLoader(_context.getStatelessServer().getClassLoader());");
    }

    protected void generateThis(JavaWriter out) throws IOException {
        out.print("bean");
    }

    protected String getSuper() {
        return "bean";
    }

    protected void generatePreReturn(JavaWriter out) throws IOException {
        out.println("isValid = true;");
    }

    protected void generatePostCall(JavaWriter out) throws IOException {
        out.popDepth();
        out.println("} finally {");
        out.println("  thread.setContextClassLoader(oldLoader);");
        out.println("  if (bean == null) {");
        out.println("  } else if (isValid)");
        out.println("    _ejb_free(bean);");
        out.println("}");
    }
}

