/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.gen.LifecycleInterceptor;
import com.caucho.ejb.gen.StatelessGenerator;
import com.caucho.ejb.gen.StatelessView;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.SessionBean;
import javax.ejb.TimedObject;
import javax.ejb.Timeout;
import javax.ejb.Timer;

public class StatelessObjectView
extends StatelessView {
    private static final L10N L = new L10N(StatelessObjectView.class);
    private String _timeoutMethod;
    private LifecycleInterceptor _postConstructInterceptor;
    private LifecycleInterceptor _preDestroyInterceptor;

    public StatelessObjectView(StatelessGenerator bean, ApiClass api) {
        super(bean, api);
    }

    public void introspect() {
        super.introspect();
        this.introspectLifecycle(this.getEjbClass().getJavaClass());
        this._postConstructInterceptor = new LifecycleInterceptor(PostConstruct.class);
        this._postConstructInterceptor.introspect(this.getEjbClass().getJavaClass());
        this._preDestroyInterceptor = new LifecycleInterceptor(PreDestroy.class);
        this._preDestroyInterceptor.introspect(this.getEjbClass().getJavaClass());
        this.introspectTimer(this.getEjbClass());
    }

    public void introspectLifecycle(Class cl) {
        if (cl == null || cl.equals(Object.class)) {
            return;
        }
        for (Method method : cl.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(PostConstruct.class)) continue;
        }
        this.introspectLifecycle(cl.getSuperclass());
    }

    public void introspectTimer(ApiClass apiClass) {
        Class cl = apiClass.getJavaClass();
        if (cl == null || cl.equals(Object.class)) {
            return;
        }
        if (TimedObject.class.isAssignableFrom(cl)) {
            this._timeoutMethod = "ejbTimeout";
            return;
        }
        for (ApiMethod apiMethod : apiClass.getMethods()) {
            Method method = apiMethod.getMethod();
            if (!method.isAnnotationPresent(Timeout.class)) continue;
            if (method.getParameterTypes().length != 1 || !Timer.class.equals(method.getParameterTypes()[0])) {
                throw new ConfigException(L.l("{0}: timeout method '{1}' does not have a (Timer) parameter", (Object)cl.getName(), (Object)method.getName()));
            }
            this._timeoutMethod = method.getName();
            this.addBusinessMethod(apiMethod);
        }
    }

    public void generateContextPrologue(JavaWriter out) throws IOException {
        String localVar = "_local_" + this.getApi().getSimpleName();
        out.println();
        out.println("private " + this.getViewClassName() + " " + localVar + ";");
    }

    public void generateContextHomeConstructor(JavaWriter out) throws IOException {
        String localVar = "_local_" + this.getApi().getSimpleName();
        out.println(localVar + " = new " + this.getViewClassName() + "(this);");
    }

    public void generateCreateProvider(JavaWriter out, String var) throws IOException {
        String localVar = "_local_" + this.getApi().getSimpleName();
        out.println();
        out.println("if (" + var + " == " + this.getApi().getName() + ".class)");
        out.println("  return " + localVar + ";");
    }

    public void generateDestroy(JavaWriter out) throws IOException {
        String localVar = "_local_" + this.getApi().getSimpleName();
        out.println();
        out.println(localVar + ".destroy();");
    }

    public void generate(JavaWriter out) throws IOException {
        this.generateBean(out);
        this.generateProxy(out);
    }

    public void generateBean(JavaWriter out) throws IOException {
        out.println();
        out.println("public static class " + this.getBeanClassName());
        out.println("  extends " + this.getEjbClass().getName());
        out.println("{");
        out.pushDepth();
        out.println("private transient " + this.getViewClassName() + " _context;");
        HashMap map = new HashMap();
        this.generateBusinessPrologue(out, map);
        this._postConstructInterceptor.generatePrologue(out, map);
        this._preDestroyInterceptor.generatePrologue(out, map);
        out.println();
        out.println(this.getBeanClassName() + "(" + this.getViewClassName() + " context)");
        out.println("{");
        out.pushDepth();
        out.println("_context = context;");
        map = new HashMap();
        this.generateBusinessConstructor(out, map);
        this._postConstructInterceptor.generateConstructor(out, map);
        this._preDestroyInterceptor.generateConstructor(out, map);
        this._postConstructInterceptor.generateCall(out);
        out.popDepth();
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    public void generateProxy(JavaWriter out) throws IOException {
        out.println();
        out.println("public static class " + this.getViewClassName());
        this.generateExtends(out);
        out.print("  implements " + this.getApi().getDeclarationName());
        out.println(", StatelessProvider");
        out.println("{");
        out.pushDepth();
        out.println();
        out.println("private static final com.caucho.ejb3.xa.XAManager _xa");
        out.println("  = new com.caucho.ejb3.xa.XAManager();");
        out.println();
        out.println("private " + this.getBean().getClassName() + " _context;");
        out.println("private " + this.getBeanClassName() + " []_freeBeanStack" + " = new " + this.getBeanClassName() + "[16];");
        out.println("private int _freeBeanTop;");
        out.println();
        out.println(this.getViewClassName() + "(" + this.getBean().getClassName() + " context)");
        out.println("{");
        this.generateSuper(out, "context.getStatelessServer(), " + this.getApi().getName() + ".class");
        out.println("  _context = context;");
        out.println("}");
        out.println("public Object __caucho_get()");
        out.println("{");
        out.println("  return this;");
        out.println("}");
        this.generateProxyPool(out);
        this.generateBusinessMethods(out);
        out.popDepth();
        out.println("}");
    }

    protected void generateExtends(JavaWriter out) throws IOException {
        out.println("extends StatelessObject");
    }

    public void generateProxyPool(JavaWriter out) throws IOException {
        String beanClass = this.getBeanClassName();
        out.println();
        out.println(beanClass + " _ejb_begin()");
        out.println("{");
        out.pushDepth();
        out.println(beanClass + " bean;");
        out.println("synchronized (this) {");
        out.println("  if (_freeBeanTop > 0) {");
        out.println("    bean = _freeBeanStack[--_freeBeanTop];");
        out.println("    return bean;");
        out.println("  }");
        out.println("}");
        out.println();
        out.println("try {");
        out.println("  bean = new " + beanClass + "(this);");
        Class implClass = this.getBean().getEjbClass().getJavaClass();
        if (SessionBean.class.isAssignableFrom(implClass)) {
            out.println("  bean.setSessionContext(_context);");
        }
        out.println("  getStatelessServer().initInstance(bean);");
        if (this.getBean().hasMethod("ejbCreate", new Class[0])) {
            out.println("  bean.ejbCreate();");
        }
        out.println("  return bean;");
        out.println("} catch (Exception e) {");
        out.println("  throw com.caucho.ejb.EJBExceptionWrapper.create(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("void _ejb_free(" + beanClass + " bean)");
        out.println("  throws javax.ejb.EJBException");
        out.println("{");
        out.pushDepth();
        out.println("if (bean == null)");
        out.println("  return;");
        out.println();
        out.println("synchronized (this) {");
        out.println("  if (_freeBeanTop < _freeBeanStack.length) {");
        out.println("    _freeBeanStack[_freeBeanTop++] = bean;");
        out.println("    return;");
        out.println("  }");
        out.println("}");
        out.println("_server.destroyInstance(bean);");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("public void destroy()");
        out.println("{");
        out.pushDepth();
        out.println(beanClass + " ptr;");
        out.println(beanClass + " []freeBeanStack;");
        out.println("int freeBeanTop;");
        out.println("synchronized (this) {");
        out.println("  freeBeanStack = _freeBeanStack;");
        out.println("  freeBeanTop = _freeBeanTop;");
        out.println("  _freeBeanStack = null;");
        out.println("  _freeBeanTop = 0;");
        out.println("}");
        out.println();
        out.println("for (int i = 0; i < freeBeanTop; i++) {");
        out.pushDepth();
        out.println("try {");
        out.println("  if (freeBeanStack[i] != null)");
        out.println("    _server.destroyInstance(freeBeanStack[i]);");
        out.println("} catch (Throwable e) {");
        out.println("  __caucho_log.log(java.util.logging.Level.WARNING, e.toString(), e);");
        out.println("}");
        out.popDepth();
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    public void generateProxyCall(JavaWriter out, Method implMethod) throws IOException {
        if (!Void.TYPE.equals(implMethod.getReturnType())) {
            out.printClass(implMethod.getReturnType());
            out.println(" result;");
        }
        out.println(this.getBeanClassName() + " bean = _ejb_begin();");
        if (!Void.TYPE.equals(implMethod.getReturnType())) {
            out.print("result = ");
        }
        out.print("bean." + implMethod.getName() + "(");
        Class<?>[] types = implMethod.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.print(" a" + i);
        }
        out.println(");");
        out.println("_ejb_free(bean);");
        if (!Void.TYPE.equals(implMethod.getReturnType())) {
            out.println("return result;");
        }
    }

    protected void generateSuper(JavaWriter out, String serverVar) throws IOException {
        out.println("super(" + serverVar + ");");
    }

    public void generateTimer(JavaWriter out) throws IOException {
        if (this._timeoutMethod != null) {
            String localVar = "_local_" + this.getApi().getSimpleName();
            out.println(this.getBeanClassName() + " bean = " + localVar + "._ejb_begin();");
            out.println("bean." + this._timeoutMethod + "(timer);");
            out.println(localVar + "._ejb_free(bean);");
        }
    }

    protected ApiMethod findImplMethod(ApiMethod apiMethod) {
        return this.getEjbClass().getMethod(apiMethod);
    }
}

