/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.gen.BusinessMethodGenerator;
import com.caucho.ejb.gen.StatelessGenerator;
import com.caucho.ejb.gen.StatelessLocalMethod;
import com.caucho.ejb.gen.View;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatelessView
extends View {
    private static final L10N L = new L10N(StatelessView.class);
    private StatelessGenerator _statelessBean;
    private ArrayList<BusinessMethodGenerator> _businessMethods = new ArrayList();

    public StatelessView(StatelessGenerator bean, ApiClass api) {
        super(bean, api);
        this._statelessBean = bean;
    }

    public StatelessGenerator getStatelessBean() {
        return this._statelessBean;
    }

    public String getContextClassName() {
        return this.getStatelessBean().getClassName();
    }

    @Override
    protected String getViewClassName() {
        return this.getApi().getSimpleName() + "__EJBLocal";
    }

    @Override
    protected String getBeanClassName() {
        return this.getApi().getSimpleName() + "__Bean";
    }

    @Override
    public ArrayList<? extends BusinessMethodGenerator> getMethods() {
        return this._businessMethods;
    }

    @Override
    public void introspect() {
        ApiClass implClass = this.getEjbClass();
        ApiClass apiClass = this.getApi();
        for (ApiMethod apiMethod : apiClass.getMethods()) {
            if (apiMethod.getDeclaringClass().equals(Object.class) || apiMethod.getDeclaringClass().getName().startsWith("javax.ejb.")) continue;
            if (apiMethod.getName().startsWith("ejb")) {
                throw new ConfigException(L.l("{0}: '{1}' must not start with 'ejb'.  The EJB spec reserves all methods starting with ejb.", (Object)apiMethod.getDeclaringClass(), (Object)apiMethod.getName()));
            }
            this.addBusinessMethod(apiMethod);
        }
    }

    protected void addBusinessMethod(ApiMethod apiMethod) {
        int index = this._businessMethods.size();
        BusinessMethodGenerator bizMethod = this.createMethod(apiMethod, index);
        if (bizMethod != null) {
            bizMethod.introspect(bizMethod.getApiMethod(), bizMethod.getImplMethod());
            this._businessMethods.add(bizMethod);
        }
    }

    public void generateCreateProvider(JavaWriter out, String var) throws IOException {
        out.println();
        out.println("if (" + var + " == " + this.getApi().getName() + ".class)");
        out.println("  return new " + this.getViewClassName() + "(this);");
    }

    protected void generateExtends(JavaWriter out) throws IOException {
        out.println("extends StatelessObject");
    }

    protected BusinessMethodGenerator createMethod(ApiMethod apiMethod, int index) {
        ApiMethod implMethod = this.findImplMethod(apiMethod);
        if (implMethod == null) {
            throw new ConfigException(L.l("'{0}' method '{1}' has no corresponding implementation in '{2}'", (Object)apiMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)StatelessView.getFullMethodName(apiMethod), (Object)this.getEjbClass().getName()));
        }
        StatelessLocalMethod bizMethod = new StatelessLocalMethod(this.getEjbClass(), this.getBeanClassName(), this, apiMethod, implMethod.getMethod(), index);
        return bizMethod;
    }

    @Override
    public void generate(JavaWriter out) throws IOException {
    }

    protected void generateSuper(JavaWriter out, String serverVar) throws IOException {
        out.println("super(" + serverVar + ");");
    }

    protected ApiMethod findImplMethod(ApiMethod apiMethod) {
        return this.getEjbClass().getMethod(apiMethod);
    }
}

