/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.cfg.ApplicationExceptionConfig;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.CallChain;
import com.caucho.java.gen.FilterCallChain;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.ejb.ApplicationException;
import javax.ejb.TransactionAttributeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionChain
extends FilterCallChain {
    private static final Logger log = Logger.getLogger(TransactionChain.class.getName());
    private static final L10N L = new L10N(TransactionChain.class);
    private ApiMethod _apiMethod;
    private ApiMethod _implMethod;
    private ApiClass _businessInterface;
    private TransactionAttributeType _xaType;
    private boolean _isEJB3;
    private ArrayList<ApplicationExceptionConfig> _appExceptions;

    public TransactionChain(CallChain next, TransactionAttributeType xaType, ApiMethod apiMethod, ApiMethod implMethod) {
        this(next, xaType, apiMethod, implMethod, false, null);
    }

    public TransactionChain(CallChain next, TransactionAttributeType xaType, ApiMethod apiMethod, ApiMethod implMethod, boolean isEJB3, ArrayList<ApplicationExceptionConfig> appExceptions) {
        super(next);
        this._xaType = xaType;
        this._apiMethod = apiMethod;
        this._implMethod = implMethod;
        this._isEJB3 = isEJB3;
        this._appExceptions = appExceptions;
        if (implMethod == null) {
            this._implMethod = apiMethod;
        }
    }

    public static TransactionChain create(CallChain next, TransactionAttributeType xaType, ApiMethod apiMethod, ApiMethod implMethod) {
        return new TransactionChain(next, xaType, apiMethod, implMethod);
    }

    public static TransactionChain create(CallChain next, TransactionAttributeType xaType, ApiMethod apiMethod, ApiMethod implMethod, boolean isEJB3, ArrayList<ApplicationExceptionConfig> appExceptions) {
        return new TransactionChain(next, xaType, apiMethod, implMethod, isEJB3, appExceptions);
    }

    @Override
    public void generateCall(JavaWriter out, String retType, String var, String[] args) throws IOException {
        if (this._isEJB3 && this._businessInterface != null) {
            out.println("if (_context != null)");
            out.println("  _context.__caucho_setInvokedBusinessInterface(" + this._businessInterface.getName() + ");");
            out.println();
        }
        out.println("Thread thread = Thread.currentThread();");
        out.println("ClassLoader oldLoader = thread.getContextClassLoader();");
        out.print("javax.transaction.Transaction oldTrans = _xaManager.getTransaction();");
        out.println();
        out.print("com.caucho.ejb.xa.TransactionContext trans");
        if (this._xaType != null) {
            switch (this._xaType) {
                case REQUIRES_NEW: {
                    out.println(" = _xaManager.beginRequiresNew();");
                    break;
                }
                case NOT_SUPPORTED: {
                    out.println(" = _xaManager.suspend();");
                    break;
                }
                case NEVER: {
                    out.println(" = _xaManager.beginNever();");
                    break;
                }
                case REQUIRED: {
                    out.println(" = _xaManager.beginRequired();");
                    break;
                }
                case MANDATORY: {
                    out.println(" = _xaManager.beginMandatory();");
                    break;
                }
                default: {
                    out.println(" = _xaManager.beginSupports();");
                }
            }
        }
        out.println("try {");
        out.pushDepth();
        out.println("thread.setContextClassLoader(_context._server.getClassLoader());");
        out.println();
        super.generateCall(out, retType, var, args);
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.pushDepth();
        Class beanClass = this._implMethod.getDeclaringClass();
        if (this._isEJB3) {
            this.generateExceptionHandling(out);
        }
        out.println("e = com.caucho.ejb.EJBExceptionWrapper.create(e);");
        out.println();
        if (this._xaType != null) {
            out.println("if (trans.getTransaction() != oldTrans) {");
            out.println("  throw trans.setRollbackOnly(e);");
            out.println("}");
        }
        out.println("throw (javax.ejb.EJBException) e;");
        out.popDepth();
        out.println("} finally {");
        out.pushDepth();
        out.println("thread.setContextClassLoader(oldLoader);");
        out.println("  trans.commit();");
        out.popDepth();
        out.println("}");
    }

    protected void generateExceptionHandling(JavaWriter out) throws IOException {
        boolean isCmt = this._xaType != null;
        out.println("if (e instanceof com.caucho.ejb.EJBExceptionWrapper)");
        out.println("  e = (Exception) e.getCause();");
        out.println();
        out.println("if (e instanceof java.lang.reflect.InvocationTargetException)");
        out.println("  e = (Exception) e.getCause();");
        out.println();
        Class beanClass = this._implMethod.getDeclaringClass();
        for (Class cl : this._implMethod.getExceptionTypes()) {
            if (!Exception.class.isAssignableFrom(cl)) {
                log.info(cl + " is not handled by EJB");
                continue;
            }
            out.println("if (e instanceof " + cl.getName() + ") {");
            out.pushDepth();
            if (isCmt) {
                boolean isApplicationException = false;
                boolean isRollback = false;
                ApplicationException ann = cl.getAnnotation(ApplicationException.class);
                if (ann != null) {
                    isApplicationException = true;
                    isRollback = ann.rollback();
                } else if (this._appExceptions != null) {
                    for (ApplicationExceptionConfig cfg : this._appExceptions) {
                        if (!cfg.getExceptionClass().equals(cl.getName())) continue;
                        isApplicationException = true;
                        isRollback = cfg.isRollback();
                        break;
                    }
                }
                if (!isApplicationException) {
                    out.println("if (trans.getTransaction() != oldTrans)");
                    out.println("  trans.setRollbackOnly(e);");
                } else if (isRollback) {
                    out.println("trans.setRollbackOnly(e);");
                }
            }
            out.println("throw (" + cl.getName() + ") e;");
            out.popDepth();
            out.println("}");
            out.println();
        }
    }
}

