/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.ejb.gen.AbstractCallChain;
import com.caucho.ejb.gen.BusinessMethodGenerator;
import com.caucho.ejb.gen.EjbCallChain;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.ejb.ApplicationException;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

public class XaCallChain
extends AbstractCallChain {
    private static final L10N L = new L10N(XaCallChain.class);
    private BusinessMethodGenerator _bizMethod;
    private EjbCallChain _next;
    private boolean _isContainerManaged = true;
    private TransactionAttributeType _xa;
    private boolean _isSynchronization;

    public XaCallChain(BusinessMethodGenerator bizMethod, EjbCallChain next) {
        super(next);
        this._bizMethod = bizMethod;
        this._next = next;
    }

    protected BusinessMethodGenerator getBusinessMethod() {
        return this._bizMethod;
    }

    public boolean isEnhanced() {
        return this._isContainerManaged && this._xa != null && !this._xa.equals((Object)TransactionAttributeType.SUPPORTS);
    }

    public boolean isContainerManaged() {
        return this._isContainerManaged;
    }

    public void setContainerManaged(boolean isContainerManaged) {
        this._isContainerManaged = isContainerManaged;
    }

    public void setTransactionType(TransactionAttributeType xa) {
        this._xa = xa;
    }

    protected TransactionAttributeType getTransactionType() {
        return this._xa;
    }

    public void setSynchronization(boolean isSynchronization) {
        this._isSynchronization = isSynchronization;
    }

    public void introspect(Method apiMethod, Method implMethod) {
        TransactionAttribute xaAttr;
        if (!this._isContainerManaged) {
            return;
        }
        Class<?> apiClass = apiMethod.getDeclaringClass();
        Class<?> implClass = null;
        if (implMethod != null) {
            implClass = implMethod.getDeclaringClass();
        }
        if ((xaAttr = apiMethod.getAnnotation(TransactionAttribute.class)) == null) {
            xaAttr = apiClass.getAnnotation(TransactionAttribute.class);
        }
        if (xaAttr == null && implMethod != null) {
            xaAttr = implMethod.getAnnotation(TransactionAttribute.class);
        }
        if (xaAttr == null && implClass != null) {
            xaAttr = implClass.getAnnotation(TransactionAttribute.class);
        }
        if (xaAttr != null) {
            this.setTransactionType(xaAttr.value());
        }
    }

    public void generatePrologue(JavaWriter out, HashMap map) throws IOException {
        if (this._isContainerManaged && map.get("caucho.ejb.xa") == null) {
            map.put("caucho.ejb.xa", "done");
            out.println();
            out.println("private static final com.caucho.ejb3.xa.XAManager _xa");
            out.println("  = new com.caucho.ejb3.xa.XAManager();");
        }
        this._next.generatePrologue(out, map);
    }

    public void generateCall(JavaWriter out) throws IOException {
        boolean isPushDepth = false;
        if (this._isContainerManaged && this._xa != null) {
            switch (this._xa) {
                case MANDATORY: {
                    out.println("_xa.beginMandatory();");
                    break;
                }
                case NEVER: {
                    out.println("_xa.beginNever();");
                    break;
                }
                case NOT_SUPPORTED: {
                    out.println("Transaction xa = _xa.beginNotSupported();");
                    out.println();
                    out.println("try {");
                    out.pushDepth();
                    isPushDepth = true;
                    break;
                }
                case REQUIRED: {
                    out.println("Transaction xa = _xa.beginRequired();");
                    out.println();
                    out.println("try {");
                    out.pushDepth();
                    isPushDepth = true;
                    break;
                }
                case REQUIRES_NEW: {
                    out.println("Transaction xa = _xa.beginRequiresNew();");
                    out.println();
                    out.println("try {");
                    out.pushDepth();
                    isPushDepth = true;
                }
            }
        }
        if (this._isSynchronization) {
            out.println("_xa.registerSynchronization(_bean);");
        }
        this.generateNext(out);
        if (this._isContainerManaged && this._xa != null) {
            if (isPushDepth) {
                out.popDepth();
            }
            for (Class<?> exn : this._bizMethod.getApiMethod().getExceptionTypes()) {
                ApplicationException appExn = exn.getAnnotation(ApplicationException.class);
                if (appExn == null) continue;
                if (!RuntimeException.class.isAssignableFrom(exn) && appExn.rollback()) {
                    out.println("} catch (" + exn.getName() + " e) {");
                    out.println("  _xa.markRollback(e);");
                    out.println("  throw e;");
                    continue;
                }
                if (!RuntimeException.class.isAssignableFrom(exn) || appExn.rollback()) continue;
                out.println("} catch (" + exn.getName() + " e) {");
                out.println("  throw e;");
            }
            switch (this._xa) {
                case REQUIRED: 
                case REQUIRES_NEW: {
                    out.println("} catch (RuntimeException e) {");
                    out.println("  _xa.markRollback(e);");
                    out.println("  throw e;");
                }
            }
            switch (this._xa) {
                case NOT_SUPPORTED: {
                    out.println("} finally {");
                    out.println("  if (xa != null)");
                    out.println("    _xa.resume(xa);");
                    out.println("}");
                    break;
                }
                case REQUIRED: {
                    out.println("} finally {");
                    out.println("  if (xa == null)");
                    out.println("    _xa.commit();");
                    out.println("}");
                    break;
                }
                case REQUIRES_NEW: {
                    out.println("} finally {");
                    out.println("  _xa.endRequiresNew(xa);");
                    out.println("}");
                }
            }
        }
    }

    protected void generateNext(JavaWriter out) throws IOException {
        this._next.generateCall(out);
    }
}

