/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen21;

import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.gen21.EntityBean;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.ClassComponent;
import com.caucho.util.L10N;
import java.io.IOException;

public class AmberBean
extends EntityBean {
    private static final L10N L = new L10N(AmberBean.class);

    public AmberBean(ApiClass ejbClass, String contextClassName, String implClassName) {
        super(ejbClass, contextClassName, implClassName);
        this.addComponent(new FlushMethod());
        if (ejbClass.hasMethod("ejbLoad", new Class[0])) {
            this.addComponent(new LoadMethod());
        }
        boolean hasRemove = ejbClass.hasMethod("ejbRemove", new Class[0]);
        this.addComponent(new RemoveMethod(hasRemove));
    }

    protected boolean isCMP() {
        return true;
    }

    protected void generateContext(JavaWriter out) throws IOException {
        super.generateContext(out);
        out.println();
        out.println("private com.caucho.amber.entity.EntityItem  __amber_cacheItem;");
        out.println();
        out.println("protected final void __caucho_setAmberCacheItem(com.caucho.amber.entity.EntityItem amber)");
        out.println("{");
        out.println("  __amber_cacheItem = amber;");
        out.println("}");
        out.println();
        out.println("protected final com.caucho.amber.entity.EntityItem __caucho_getAmberCacheItem()");
        out.println("{");
        out.println("  if (__amber_cacheItem == null)");
        out.println("    __amber_cacheItem = _server.getAmberCacheItem(getPrimaryKey());");
        out.println("  return __amber_cacheItem;");
        out.println("}");
        out.println();
        out.println("protected final " + this.getImplClassName() + " __caucho_getAmberCacheEntity()");
        out.println("{");
        out.println("  if (__amber_cacheItem == null)");
        out.println("    __amber_cacheItem = _server.getAmberCacheItem(getPrimaryKey());");
        out.println("  return (" + this.getImplClassName() + ") __amber_cacheItem.getEntity();");
        out.println("}");
    }

    protected void generateStore(JavaWriter out) throws IOException {
    }

    protected void generateLoad(JavaWriter out) throws IOException {
        out.println("if (doLoad) {");
        out.println("  try {");
        out.println("    ptr.__caucho_retrieve_eager(trans.getAmberConnection());");
        out.println("  } catch (Exception e) { throw com.caucho.ejb.EJBExceptionWrapper.createRuntime(e); }");
        out.println("  ptr._ejb_state = QEntity._CAUCHO_IS_LOADED;");
        out.println("}");
    }

    private static boolean hasMethod(Class cl, String name, Class[] param) {
        try {
            return cl.getMethod(name, param) != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    static class RemoveMethod
    extends ClassComponent {
        private boolean _hasRemove;

        RemoveMethod(boolean hasRemove) {
            this._hasRemove = hasRemove;
        }

        public void generate(JavaWriter out) throws IOException {
            out.println("public void ejbRemove()");
            out.println("{");
            out.pushDepth();
            out.println("try {");
            out.pushDepth();
            if (this._hasRemove) {
                out.println("super.ejbRemove();");
            }
            out.println("_ejb_state = com.caucho.ejb.entity.EntityObject._CAUCHO_IS_DEAD;");
            out.println("__caucho_delete();");
            out.popDepth();
            out.println("} catch (Exception e) {");
            out.println("  __caucho_log.log(java.util.logging.Level.WARNING, e.toString(), e);");
            out.println("}");
            out.popDepth();
            out.println("}");
        }
    }

    static class LoadMethod
    extends ClassComponent {
        LoadMethod() {
        }

        public void generate(JavaWriter out) throws IOException {
            out.println("protected void __caucho_load_callback()");
            out.println("{");
            out.println("  try {");
            out.println("    ejbLoad();");
            out.println("  } catch (Throwable e) {");
            out.println("    __caucho_log.log(java.util.logging.Level.WARNING, e.toString(), e);");
            out.println("  }");
            out.println("}");
        }
    }

    static class FlushMethod
    extends ClassComponent {
        FlushMethod() {
        }

        public void generate(JavaWriter out) throws IOException {
            out.println("protected void __caucho_flush_callback()");
            out.println("  throws java.sql.SQLException");
            out.println("{");
            out.println("  ejbStore();");
            out.println("}");
        }
    }
}

