/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen21;

import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.cfg21.CmrManyToMany;
import com.caucho.ejb.cfg21.CmrManyToOne;
import com.caucho.ejb.cfg21.CmrRelation;
import com.caucho.ejb.cfg21.EjbEntityBean;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.BaseClass;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.Set;

public class CollectionClass
extends BaseClass {
    private static final L10N L = new L10N(CollectionClass.class);
    private CmrRelation _oneToMany;

    public CollectionClass(CmrRelation oneToMany, String className) {
        this._oneToMany = oneToMany;
        this.setClassName(className);
        Class retType = oneToMany.getGetter().getReturnType();
        if (Set.class.isAssignableFrom(retType)) {
            this.setSuperClassName("com.caucho.ejb.entity.CmpSetImpl");
        } else {
            this.setSuperClassName("com.caucho.ejb.entity.CmpCollectionImpl");
        }
    }

    public void generateClassContent(JavaWriter out) throws IOException {
        this.generateConstructor(out);
        this.generateAdd(out);
        this.generateRemove(out);
        super.generateClassContent(out);
    }

    public void generateConstructor(JavaWriter out) throws IOException {
        EjbEntityBean sourceBean = this._oneToMany.getBean();
        String sourceType = sourceBean.getLocal().getName();
        out.println();
        out.println("Bean _bean;");
        out.println(sourceType + " _beanLocal;");
        out.println();
        out.println("public " + this.getClassName() + "(Bean bean, com.caucho.amber.AmberQuery query)");
        out.println("{");
        out.pushDepth();
        out.println("_bean = bean;");
        out.println("_beanLocal = bean._ejb_context._viewLocal;");
        out.println("fill(query);");
        out.popDepth();
        out.println("}");
    }

    public void generateAdd(JavaWriter out) throws IOException {
        out.println();
        out.println("public boolean addImpl(Object v)");
        out.println("{");
        out.pushDepth();
        EjbEntityBean targetBean = this._oneToMany.getTargetBean();
        String targetType = targetBean.getLocal().getName();
        out.println("if (v == null)");
        out.println("  return false;");
        out.println("else if (! (v instanceof " + targetType + "))");
        out.println("  throw new IllegalArgumentException(v.getClass().getName() + \": \" + v);");
        CmrRelation targetRelation = this._oneToMany.getTargetRelation();
        if (targetRelation instanceof CmrManyToOne) {
            CmrManyToOne manyToOne = (CmrManyToOne)targetRelation;
            ApiMethod setter = manyToOne.getSetter();
            if (setter != null) {
                out.println(targetType + " bean = (" + targetType + ") v;");
                ApiMethod localDstSetter = EjbEntityBean.getMethod(targetBean.getLocal(), setter);
                if (localDstSetter != null) {
                    out.print("bean");
                } else {
                    out.print("((" + targetBean.getEJBClass().getName() + ") ");
                    out.print("((com.caucho.ejb.entity.EntityObject) bean)._caucho_getBean(_ejb_trans, true))");
                }
                out.println("." + setter.getName() + "(_beanLocal);");
            }
        } else if (this._oneToMany instanceof CmrManyToMany) {
            CmrManyToMany manyToMany = (CmrManyToMany)this._oneToMany;
            ApiMethod getter = manyToMany.getGetter();
            if (manyToMany.isTargetUnique()) {
                out.println("_bean.__amber_" + getter.getName() + "_remove_target(v);");
            }
            out.println("_bean.__amber_" + getter.getName() + "_add(_bean.__caucho_getConnection(), v);");
        }
        out.println("return true;");
        out.popDepth();
        out.println("}");
    }

    public void generateRemove(JavaWriter out) throws IOException {
        out.println();
        out.println("protected boolean removeImpl(Object v)");
        out.println("{");
        out.pushDepth();
        EjbEntityBean targetBean = this._oneToMany.getTargetBean();
        String targetType = targetBean.getLocal().getName();
        out.println("if (v == null)");
        out.println("  return false;");
        out.println("else if (! (v instanceof " + targetType + "))");
        out.println("  throw new IllegalArgumentException(v.getClass().getName() + \": \" + v);");
        CmrRelation targetRelation = this._oneToMany.getTargetRelation();
        if (targetRelation instanceof CmrManyToOne) {
            CmrManyToOne manyToOne = (CmrManyToOne)targetRelation;
            ApiMethod setter = manyToOne.getSetter();
            ApiMethod getter = manyToOne.getGetter();
            if (setter != null) {
                out.println("if (_bean != null) {");
                out.pushDepth();
                out.println(targetType + " bean = (" + targetType + ") v;");
                out.println("if (_beanLocal != null) {");
                out.pushDepth();
                ApiMethod localDstSetter = EjbEntityBean.getMethod(targetBean.getLocal(), setter);
                String bean = "bean";
                if (localDstSetter == null) {
                    String beanClass = targetBean.getEJBClass().getName();
                    out.print(beanClass + " bean1 = ((" + beanClass + ") ");
                    out.print("((com.caucho.ejb.entity.EntityObject) bean)._caucho_getBean(_ejb_trans, true));");
                    bean = "bean1";
                }
                out.println("if (_beanLocal.equals(" + bean + "." + getter.getName() + "())) {");
                out.pushDepth();
                out.println(bean + "." + setter.getName() + "(null);");
                out.popDepth();
                out.println("}");
                out.popDepth();
                out.println("}");
                out.popDepth();
                out.println("}");
                out.println();
            }
        } else if (this._oneToMany instanceof CmrManyToMany) {
            CmrManyToMany manyToMany = (CmrManyToMany)this._oneToMany;
            ApiMethod getter = manyToMany.getGetter();
            out.println("_bean.__amber_" + getter.getName() + "_remove(v);");
        }
        out.println("return true;");
        out.popDepth();
        out.println("}");
    }
}

