/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen21;

import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.gen21.EntityPoolChain;
import com.caucho.ejb.gen21.ViewClass;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.BaseMethod;
import com.caucho.java.gen.CallChain;
import com.caucho.util.L10N;
import java.io.IOException;

public class EntityView
extends ViewClass {
    private static L10N L = new L10N(EntityView.class);
    private ApiClass _remoteClass;
    private String _prefix;
    private String _contextClassName;

    public EntityView(ApiClass remoteClass, String contextClassName, String prefix) {
        super(prefix, "EntityObject");
        this.addInterfaceName(remoteClass.getName());
        this._contextClassName = contextClassName;
        this._prefix = prefix;
        this.setStatic(true);
    }

    public CallChain createPoolChain(CallChain call, BaseMethod method) {
        return new EntityPoolChain(call, false);
    }

    public void generate(JavaWriter out) throws IOException {
        this.generateGetter(out);
        out.println();
        super.generate(out);
    }

    private void generateGetter(JavaWriter out) throws IOException {
        out.println("private " + this._prefix + " _view" + this._prefix + ";");
        out.println();
        if (this._prefix.equals("Local")) {
            out.println("public EJBLocalObject getEJBLocalObject()");
        } else {
            out.println("public EJBObject getRemoteView()");
        }
        out.println("{");
        out.println("  if (_view" + this._prefix + " == null)");
        out.println("    _view" + this._prefix + " = new " + this._prefix + "(this);");
        out.println();
        out.println("  return _view" + this._prefix + ";");
        out.println("}");
    }

    protected void generateClassContent(JavaWriter out) throws IOException {
        out.println("private " + this._contextClassName + " _context;");
        out.println("private EjbTransactionManager _xaManager;");
        out.println();
        out.println(this._prefix + "(" + this._contextClassName + " context)");
        out.println("{");
        out.println("  _context = context;");
        out.println("  _xaManager = context.getEntityServer().getTransactionManager();");
        out.println("}");
        out.println();
        out.println("public QEntityContext getEntityContext()");
        out.println("{");
        out.println("  return _context;");
        out.println("}");
        this.generateGetBean(out);
        this.generateComponents(out);
    }

    protected void generateGetBean(JavaWriter out) throws IOException {
        out.println();
        out.println("public Object _caucho_getBean(com.caucho.ejb.xa.TransactionContext trans, boolean doLoad)");
        out.println("{");
        out.pushDepth();
        out.println("return _context._ejb_begin(trans, false, true);");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("public Object _caucho_getBean()");
        out.println("{");
        out.pushDepth();
        out.println("com.caucho.ejb.xa.TransactionContext trans;");
        out.println("trans = _context._server.getTransactionManager().getTransactionContext();");
        out.println("return _context._ejb_begin(trans, false, false);");
        out.popDepth();
        out.println("}");
    }
}

