/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen21;

import com.caucho.ejb.gen21.JVMStubGenerator;
import com.caucho.make.ClassDependency;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import java.io.IOException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class JVMHomeStubGenerator
extends JVMStubGenerator {
    protected ArrayList<PersistentDependency> _dependList;

    public JVMHomeStubGenerator(Class remoteHomeClass, boolean isProxy) {
        this._remoteClass = remoteHomeClass;
        this._isProxy = isProxy;
        if (isProxy) {
            this.setFullClassName(remoteHomeClass.getName() + "__JVMProxy");
        } else {
            this.setFullClassName(remoteHomeClass.getName() + "__JVMStub");
        }
        MergePath mergePath = new MergePath();
        this.setSearchPath((Path)mergePath);
        this._dependList = new ArrayList();
        this._dependList.add(new ClassDependency(remoteHomeClass));
    }

    public Class generateStub() throws Exception {
        Class home = this.preload();
        if (home != null) {
            return home;
        }
        this.generate();
        return this.compile();
    }

    public void generateJava() throws IOException {
        this.printHeader();
        Method[] methods = this._remoteClass.getMethods();
        block0: for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodName = method.getName();
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass.getName().startsWith("javax.ejb.")) continue;
            Class<?>[] exns = method.getExceptionTypes();
            for (int j = 0; j < exns.length; ++j) {
                if (!exns[j].isAssignableFrom(RemoteException.class)) continue;
                this.printMethod(method.getName(), method);
                continue block0;
            }
        }
        this.printDependList(this._dependList);
        this.printFooter();
    }

    protected void printHeader() throws IOException {
        if (this.getPackageName() != null) {
            this.println("package " + this.getPackageName() + ";");
        }
        this.println();
        this.println("import java.io.*;");
        this.println("import java.rmi.*;");
        this.println("import " + this._remoteClass.getName() + ";");
        this.println();
        this.println("public class " + this.getClassName());
        this.println("  extends com.caucho.ejb.JVMHome");
        this.println("  implements " + this._remoteClass.getName());
        this.println("{");
        this.pushDepth();
    }
}

