/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen21;

import com.caucho.ejb.gen21.JVMStubGenerator;
import com.caucho.make.ClassDependency;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import java.io.IOException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class JVMObjectStubGenerator
extends JVMStubGenerator {
    private ArrayList<PersistentDependency> _dependList;

    public JVMObjectStubGenerator(Class remoteClass, boolean isProxy) {
        this._remoteClass = remoteClass;
        this._isProxy = isProxy;
        if (isProxy) {
            this.setFullClassName(remoteClass.getName() + "__JVMProxy");
        } else {
            this.setFullClassName(remoteClass.getName() + "__JVMStub");
        }
        MergePath mergePath = new MergePath();
        this.setSearchPath((Path)mergePath);
        this._dependList = new ArrayList();
        this._dependList.add(new ClassDependency(remoteClass));
    }

    public Class generateStub() throws Exception {
        Class object = this.preload();
        if (object != null) {
            return object;
        }
        this.generate();
        return this.compile();
    }

    public void generateJava() throws IOException {
        this.printHeader();
        Method[] methods = this._remoteClass.getMethods();
        block0: for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodName = method.getName();
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass.getName().startsWith("javax.ejb.")) continue;
            Class<?>[] exns = method.getExceptionTypes();
            for (int j = 0; j < exns.length; ++j) {
                if (!exns[j].isAssignableFrom(RemoteException.class)) continue;
                this.printMethod(method.getName(), method);
                continue block0;
            }
        }
        this.printRemove();
        this.printDependList(this._dependList);
        this.printFooter();
    }

    protected void printHeader() throws IOException {
        if (this.getPackageName() != null) {
            this.println("package " + this.getPackageName() + ";");
        }
        this.println();
        this.println("import java.io.*;");
        this.println("import java.rmi.*;");
        this.println("import " + this._remoteClass.getName() + ";");
        this.println();
        this.println("public class " + this.getClassName());
        this.println("  extends com.caucho.ejb.JVMObject");
        this.println("  implements " + this._remoteClass.getName());
        this.println("{");
        this.pushDepth();
    }

    protected void printRemove() throws IOException {
        Class<Void> ret = Void.TYPE;
        Class[] params = new Class[]{};
        this.println();
        this.println("public void remove() throws java.rmi.RemoteException, javax.ejb.RemoveException");
        this.printMethodHead(params, ret);
        this.printCall("remove", params, Void.TYPE);
        this.printMethodFooter(ret, false);
    }
}

