/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen21;

import com.caucho.ejb.Version;
import com.caucho.java.AbstractGenerator;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.vfs.IOExceptionWrapper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;

abstract class JVMStubGenerator
extends AbstractGenerator {
    protected static final L10N L = new L10N(JVMStubGenerator.class);
    static IntMap _immutableClasses = new IntMap();
    protected boolean _isProxy = false;
    protected ArrayList<Method> _proxyMethods = new ArrayList();
    protected Class _remoteClass;

    JVMStubGenerator() {
    }

    void setProxy(boolean isProxy) {
        this._isProxy = isProxy;
    }

    protected abstract void printHeader() throws IOException;

    protected void printMethod(String name, Method method) throws IOException {
        Class<?> ret = method.getReturnType();
        Class[] params = method.getParameterTypes();
        this.printMethodHeader(name, method);
        boolean needsSerialization = this.printMethodHead(params, ret);
        this.printCall(method.getName(), params, ret);
        this.printMethodFooter(ret, needsSerialization);
    }

    protected boolean printMethodHead(Class[] params, Class ret) throws IOException {
        this.println("{");
        this.pushDepth();
        this.println("Thread thread = Thread.currentThread();");
        this.println("ClassLoader oldLoader = thread.getContextClassLoader();");
        boolean needsSerialization = false;
        for (int i = 0; i < params.length; ++i) {
            if (!this.needsSerialization(params[i])) continue;
            if (!needsSerialization) {
                this.println("com.caucho.ejb.protocol.SelfSerializer ser;");
                this.println("ser = com.caucho.ejb.protocol.SelfSerializer.allocate();");
            }
            this.println("ser.write(a" + i + ");");
            needsSerialization = true;
        }
        if (this.needsSerialization(ret) && !needsSerialization) {
            this.println("com.caucho.ejb.protocol.SelfSerializer ser;");
            this.println("ser = com.caucho.ejb.protocol.SelfSerializer.allocate();");
            needsSerialization = true;
        }
        if (!ret.getName().equals("void")) {
            this.printClass(ret);
            this.println(" _ret;");
        }
        this.println();
        if (!this._isProxy) {
            this.println(this._remoteClass.getName() + " obj;");
            this.println("obj = (" + this._remoteClass.getName() + ") _caucho_getObject();");
        } else {
            this.println("Object obj = _caucho_getObject();");
        }
        this.println("thread.setContextClassLoader(_caucho_getClassLoader());");
        this.println("try {");
        this.pushDepth();
        return needsSerialization;
    }

    protected void printMethodFooter(Class ret, boolean needsSerialization) throws IOException {
        if (this.needsSerialization(ret)) {
            if (needsSerialization) {
                this.println("ser.clear();");
            }
            needsSerialization = true;
            this.println("ser.write(_ret);");
            this.println("thread.setContextClassLoader(oldLoader);");
            this.print("_ret = (");
            this.printClass(ret);
            this.println(") ser.read();");
        }
        this.popDepth();
        this.println("} finally {");
        this.pushDepth();
        this.println("thread.setContextClassLoader(oldLoader);");
        if (needsSerialization) {
            this.println("ser.close();");
        }
        this.popDepth();
        this.println("}");
        if (!ret.getName().equals("void")) {
            this.println("return _ret;");
        }
        this.popDepth();
        this.println("}");
    }

    void printCall(String name, Class[] params, Class retType) throws IOException {
        if (this._isProxy) {
            this.printProxyCall(name, params, retType);
            return;
        }
        if (!retType.equals(Void.TYPE)) {
            this.print("_ret = ");
        }
        this.print("obj." + name + "(");
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            if (this.needsSerialization(params[i])) {
                this.print("(");
                this.printClass(params[i]);
                this.print(") ser.read()");
                continue;
            }
            this.print("a" + i);
        }
        this.println(");");
    }

    void printProxyCall(String name, Class[] params, Class retType) throws IOException {
        Method method;
        try {
            method = this._remoteClass.getMethod(name, params);
        }
        catch (NoSuchMethodException e) {
            throw new IOExceptionWrapper((Throwable)e);
        }
        this._proxyMethods.add(method);
        if (this._isProxy) {
            this.println("try {");
            this.pushDepth();
        }
        int index = this._proxyMethods.size() - 1;
        boolean retNeedsSerialization = this.needsSerialization(retType);
        if (!retType.equals(Void.TYPE)) {
            if (!retNeedsSerialization) {
                this.print("_ret = (");
                this.printClass(retType);
                this.print(")");
            } else {
                this.print("Object _oret = ");
            }
        }
        if (retType.isPrimitive()) {
            this.print("com.caucho.ejb.JVMObject.to_" + retType.getName() + "(");
        }
        this.print("method" + index + ".invoke(obj, new Object[] {");
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            if (this.needsSerialization(params[i])) {
                this.print("(");
                this.printClass(params[i]);
                this.print(") ser.read()");
                continue;
            }
            if (params[i].isPrimitive()) {
                this.printToObject("a" + i, params[i]);
                continue;
            }
            this.print("a" + i);
        }
        if (retType.isPrimitive()) {
            this.println("}));");
        } else {
            this.println("});");
        }
        if (retNeedsSerialization) {
            this.println("ser.clear();");
            this.println("ser.write(_oret);");
            this.println("thread.setContextClassLoader(oldLoader);");
            this.print("_ret = (");
            this.printClass(method.getReturnType());
            this.println(") ser.read();");
        }
        this.popDepth();
        this.println("} catch (java.lang.IllegalAccessException e) {");
        this.println("  throw com.caucho.ejb.EJBExceptionWrapper.createRuntime(e);");
        this.println("} catch (java.lang.reflect.InvocationTargetException e) {");
        this.println("  throw com.caucho.ejb.EJBExceptionWrapper.createRuntime(e);");
        this.println("}");
    }

    void printToObject(String name, Class cl) throws IOException {
        if (Boolean.TYPE.equals(cl)) {
            this.print("new Boolean(" + name + ")");
        } else if (Byte.TYPE.equals(cl)) {
            this.print("new Byte(" + name + ")");
        } else if (Short.TYPE.equals(cl)) {
            this.print("new Short(" + name + ")");
        } else if (Character.TYPE.equals(cl)) {
            this.print("new Character(" + name + ")");
        } else if (Integer.TYPE.equals(cl)) {
            this.print("new Integer(" + name + ")");
        } else if (Long.TYPE.equals(cl)) {
            this.print("new Long(" + name + ")");
        } else if (Float.TYPE.equals(cl)) {
            this.print("new Float(" + name + ")");
        } else if (Double.TYPE.equals(cl)) {
            this.print("new Double(" + name + ")");
        } else {
            throw new RuntimeException(L.l("can't create object for type {0}", (Object)cl.getName()));
        }
    }

    void printFooter() throws IOException {
        int i;
        for (i = 0; i < this._proxyMethods.size(); ++i) {
            this.println("static java.lang.reflect.Method method" + i + ";");
        }
        if (this._proxyMethods.size() > 0) {
            this.println("protected void _caucho_init_methods(Class cl)");
            this.println("{");
            this.pushDepth();
            this.println("try {");
            this.pushDepth();
            for (i = 0; i < this._proxyMethods.size(); ++i) {
                Method method = this._proxyMethods.get(i);
                this.print("method" + i + " = cl.getMethod(\"");
                this.print(method.getName());
                this.print("\", new Class[] {");
                Class<?>[] paramTypes = method.getParameterTypes();
                for (int j = 0; j < paramTypes.length; ++j) {
                    if (j != 0) {
                        this.print(", ");
                    }
                    this.printClass(paramTypes[j]);
                    this.print(".class");
                }
                this.println("});");
            }
            this.popDepth();
            this.println("} catch (Exception e) {");
            this.println("  com.caucho.ejb.EJBExceptionWrapper.createRuntime(e);");
            this.println("}");
            this.popDepth();
            this.println("}");
        }
        this.popDepth();
        this.println("}");
    }

    boolean needsSerialization(Class cl) {
        if (cl.isPrimitive()) {
            return false;
        }
        if (!this._isProxy && EJBObject.class.isAssignableFrom(cl)) {
            return false;
        }
        if (!this._isProxy && EJBLocalObject.class.isAssignableFrom(cl)) {
            return false;
        }
        if (!this._isProxy && EJBHome.class.isAssignableFrom(cl)) {
            return false;
        }
        if (!this._isProxy && EJBLocalHome.class.isAssignableFrom(cl)) {
            return false;
        }
        return _immutableClasses.get((Object)cl) < 0;
    }

    protected void printVersionChange() throws IOException {
        this.println("if (com.caucho.ejb.Version.getVersionId() != " + Version.getVersionId() + ")");
        this.println("  return true;");
    }

    static {
        _immutableClasses.put(String.class, 1);
        _immutableClasses.put(Byte.class, 1);
        _immutableClasses.put(Character.class, 1);
        _immutableClasses.put(Short.class, 1);
        _immutableClasses.put(Integer.class, 1);
        _immutableClasses.put(Long.class, 1);
        _immutableClasses.put(Float.class, 1);
        _immutableClasses.put(Double.class, 1);
        _immutableClasses.put(Class.class, 1);
    }
}

