/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.config.ConfigException;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.EJBExceptionWrapper;
import com.caucho.ejb.hessian.HessianHandle;
import com.caucho.ejb.hessian.HessianHandleEncoder;
import com.caucho.ejb.hessian.HessianHomeHandle;
import com.caucho.ejb.hessian.MetaStub;
import com.caucho.ejb.protocol.EjbProtocolManager;
import com.caucho.ejb.protocol.HandleEncoder;
import com.caucho.hessian.client.HessianProxyFactory;
import com.caucho.hessian.io.HessianRemoteResolver;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBHome;

public class HessianClientContainer
implements HessianRemoteResolver {
    private static final Logger log = Logger.getLogger(HessianClientContainer.class.getName());
    protected static L10N L = new L10N(HessianClientContainer.class);
    private static EnvironmentLocal _hessianClient = new EnvironmentLocal("caucho.hessian.client");
    private String _serverId;
    private HessianHandleEncoder _handleEncoder;
    private HessianProxyFactory _proxyFactory;
    EJBHome _ejbHome;
    Class _homeClass;
    Class _remoteClass;
    Class _homeStubClass;
    Class _remoteStubClass;
    Class _primaryKeyClass;
    private String _basicAuth;

    HessianClientContainer(String serverId) throws ConfigException {
        this._serverId = serverId;
        this._proxyFactory = new HessianProxyFactory();
        Environment.addCloseListener(this);
    }

    static HessianClientContainer find(String serverId) {
        try {
            Hashtable<String, HessianClientContainer> map = (Hashtable<String, HessianClientContainer>)_hessianClient.getLevel();
            HessianClientContainer client = null;
            if (map != null) {
                client = (HessianClientContainer)map.get(serverId);
            }
            if (client == null) {
                client = new HessianClientContainer(serverId);
                if (map == null) {
                    map = new Hashtable<String, HessianClientContainer>();
                }
                map.put(serverId, client);
                _hessianClient.set(map);
                try {
                    URL url = new URL(serverId);
                    InputStream is = url.openStream();
                    is.close();
                }
                catch (IOException e) {
                    log.log(Level.FINEST, e.toString(), e);
                }
            }
            return client;
        }
        catch (Exception e) {
            throw EJBExceptionWrapper.createRuntime(e);
        }
    }

    protected EJBHome getHomeStub() throws ConfigException {
        try {
            return (EJBHome)this._proxyFactory.create(this.getHomeClass(), this._serverId);
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    protected Object createObjectStub(String url) throws ConfigException {
        try {
            return this._proxyFactory.create(this.getRemoteClass(), url);
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    HessianHomeHandle getHomeHandle() {
        return new HessianHomeHandle(this._ejbHome, this._serverId);
    }

    HessianHandle createHandle(String url) {
        return new HessianHandle(url);
    }

    public HandleEncoder getHandleEncoder() {
        try {
            if (this._handleEncoder == null) {
                this._handleEncoder = new HessianHandleEncoder(null, this._serverId, this.getPrimaryKeyClass());
            }
            return this._handleEncoder;
        }
        catch (Exception e) {
            throw EJBExceptionWrapper.createRuntime(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class getHomeClass() throws ConfigException {
        if (this._homeClass != null) {
            return this._homeClass;
        }
        try {
            HessianClientContainer hessianClientContainer = this;
            synchronized (hessianClientContainer) {
                if (this._homeClass != null) {
                    return this._homeClass;
                }
                String className = this.getHomeClassName();
                this._homeClass = CauchoSystem.loadClass(className, false, null);
            }
        }
        catch (ClassNotFoundException e) {
            throw ConfigException.create((Throwable)e);
        }
        return this._homeClass;
    }

    String getHomeClassName() throws ConfigException {
        AbstractServer server = EjbProtocolManager.getJVMServer(this._serverId);
        if (server != null) {
            Class cl = server.getRemoteHomeClass();
            if (cl != null) {
                return cl.getName();
            }
            throw new ConfigException(L.l("'{0}' has no remote interface.", (Object)this._serverId));
        }
        try {
            Path path = Vfs.lookup(this._serverId);
            return (String)MetaStub.call(path, "_hessian_getAttribute", "java.home.class");
        }
        catch (Throwable e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class getRemoteClass() throws ConfigException {
        if (this._remoteClass != null) {
            return this._remoteClass;
        }
        try {
            HessianClientContainer hessianClientContainer = this;
            synchronized (hessianClientContainer) {
                if (this._remoteClass != null) {
                    return this._remoteClass;
                }
                String className = this.getRemoteClassName();
                if (className == null || className.equals("null")) {
                    return null;
                }
                this._remoteClass = CauchoSystem.loadClass(className, false, null);
            }
        }
        catch (ClassNotFoundException e) {
            throw ConfigException.create((Throwable)e);
        }
        return this._remoteClass;
    }

    String getRemoteClassName() throws ConfigException {
        AbstractServer server = EjbProtocolManager.getJVMServer(this._serverId);
        if (server != null) {
            Class cl = server.getRemoteObjectClass();
            if (cl != null) {
                return cl.getName();
            }
            throw new ConfigException(L.l("`{0}' has no remote interface.", (Object)this._serverId));
        }
        try {
            Path path = Vfs.lookup(this._serverId);
            return (String)MetaStub.call(path, "_hessian_getAttribute", "java.object.class");
        }
        catch (Throwable e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class getPrimaryKeyClass() throws ConfigException {
        if (this._primaryKeyClass != null) {
            return this._primaryKeyClass;
        }
        try {
            HessianClientContainer hessianClientContainer = this;
            synchronized (hessianClientContainer) {
                if (this._primaryKeyClass != null) {
                    return this._primaryKeyClass;
                }
                String className = this.getPrimaryKeyClassName();
                this._primaryKeyClass = CauchoSystem.loadClass(className, false, null);
            }
        }
        catch (ClassNotFoundException e) {
            throw ConfigException.create((Throwable)e);
        }
        return this._primaryKeyClass;
    }

    String getPrimaryKeyClassName() throws ConfigException {
        AbstractServer server = EjbProtocolManager.getJVMServer(this._serverId);
        if (server != null) {
            Class cl = server.getPrimaryKeyClass();
            if (cl != null) {
                return cl.getName();
            }
            throw new ConfigException(L.l("`{0}' has no remote interface.", (Object)this._serverId));
        }
        try {
            Path path = Vfs.lookup(this._serverId);
            return (String)MetaStub.call(path, "_hessian_getAttribute", "primary-key-class");
        }
        catch (Throwable e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public Object lookup(String type, String url) throws IOException {
        try {
            Class api = CauchoSystem.loadClass(type);
            return this.create(api, url);
        }
        catch (Exception e) {
            throw new IOException(String.valueOf(e));
        }
    }

    public Object create(Class api, String url) throws Exception {
        return this._proxyFactory.create(api, url);
    }

    String getBasicAuthentication() {
        return this._basicAuth;
    }

    void setBasicAuthentication(String auth) {
        this._basicAuth = auth != null ? "Basic " + auth : auth;
    }

    public void close() {
    }

    public String toString() {
        return "HessianClientContainer[" + this._serverId + "]";
    }
}

