/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.ejb.EJBExceptionWrapper;
import com.caucho.ejb.RemoteExceptionWrapper;
import com.caucho.ejb.hessian.HessianClientContainer;
import com.caucho.ejb.protocol.AbstractHandle;
import com.caucho.ejb.protocol.HandleEncoder;
import java.rmi.RemoteException;
import javax.ejb.EJBObject;

public class HessianHandle
extends AbstractHandle {
    private String url;
    private transient String serverId;
    private transient String objectId;
    private transient Object objectKey;
    private transient EJBObject object;

    public HessianHandle() {
    }

    public HessianHandle(String url) {
        this.url = url;
    }

    public HessianHandle(String url, Object key) {
        this.url = url;
        this.objectKey = key;
    }

    public String getServerId() {
        if (this.serverId == null) {
            int p = this.url.lastIndexOf(63);
            this.serverId = this.url.substring(0, p);
        }
        return this.serverId;
    }

    public String getObjectId() {
        if (this.objectId == null) {
            int p = this.url.lastIndexOf(63);
            this.objectId = this.url.substring(p + 7);
        }
        return this.objectId;
    }

    void setEJBObject(EJBObject obj) {
        this.object = obj;
    }

    public EJBObject getEJBObject() throws RemoteException {
        if (this.object == null) {
            try {
                HessianClientContainer client = HessianClientContainer.find(this.getServerId());
                this.object = (EJBObject)client.createObjectStub(this.url);
            }
            catch (Exception e) {
                throw RemoteExceptionWrapper.create(e);
            }
        }
        return this.object;
    }

    public Object getObjectKey() {
        if (this.objectKey == null) {
            try {
                HandleEncoder encoder = HessianClientContainer.find(this.getServerId()).getHandleEncoder();
                this.objectKey = encoder.objectIdToKey(this.getObjectId());
            }
            catch (Exception e) {
                throw new EJBExceptionWrapper(e);
            }
        }
        return this.objectKey;
    }

    public String getURL() {
        return this.url;
    }

    public String getURL(String protocol) {
        return this.url;
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HessianHandle)) {
            return false;
        }
        HessianHandle handle = (HessianHandle)obj;
        return this.url.equals(handle.url);
    }

    public String toString() {
        return this.url;
    }
}

