/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.ejb.hessian.HessianClientContainer;
import com.caucho.naming.AbstractModel;
import com.caucho.naming.NamingExceptionWrapper;
import com.caucho.services.name.NameServerRemote;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;
import javax.ejb.EJBHome;
import javax.naming.NamingException;

public class HessianModel
extends AbstractModel {
    private static final Logger log = Logger.getLogger(HessianModel.class.getName());
    private static L10N L = new L10N(HessianModel.class);
    private String _urlPrefix;
    private String _namePrefix;
    private HessianModel _root;
    private Hashtable _cache;
    private HessianClientContainer _client;
    private NameServerRemote _remoteRoot;
    private NameServerRemote _remote;

    public HessianModel(String prefix) {
        if (!prefix.endsWith("/")) {
            prefix = prefix + '/';
        }
        this._urlPrefix = prefix;
        this._namePrefix = "/";
        this._root = this;
        this._cache = new Hashtable();
    }

    public HessianModel(String namePrefix, HessianModel root) {
        if (!namePrefix.endsWith("/")) {
            namePrefix = namePrefix + '/';
        }
        this._namePrefix = namePrefix;
        this._root = root;
    }

    void setRemote(NameServerRemote remote) {
        this._remote = remote;
    }

    void setClientContainer(HessianClientContainer client) {
        this._root._client = client;
    }

    public AbstractModel copy() {
        return this;
    }

    String getURLPrefix() {
        return this._root._urlPrefix;
    }

    public Object lookup(String name) throws NamingException {
        try {
            String urlPrefix = this.getURLPrefix();
            String cacheName = urlPrefix + this._namePrefix + name;
            Object obj = this._root._cache.get(cacheName);
            if (obj != null) {
                return obj;
            }
            if (this._root._remoteRoot == null) {
                if (this._root._client == null) {
                    this._root._client = HessianClientContainer.find(urlPrefix);
                }
                Object stub = this._client.createObjectStub(urlPrefix);
                this._root._remoteRoot = (NameServerRemote)stub;
            }
            if ((obj = this._root._remoteRoot.lookup(this._namePrefix + name)) instanceof EJBHome) {
                this._root._cache.put(cacheName, obj);
            } else if (obj instanceof NameServerRemote) {
                HessianModel model = new HessianModel(this._namePrefix + name, this._root);
                NameServerRemote remote = (NameServerRemote)obj;
                model.setRemote(remote);
                obj = model;
                this._root._cache.put(cacheName, obj);
            }
            return obj;
        }
        catch (Exception e) {
            throw new NamingExceptionWrapper(e);
        }
    }

    public List list() throws NamingException {
        try {
            if (this._remote == null) {
                Object obj;
                if (this._root._remoteRoot == null) {
                    if (this._root._client == null) {
                        this._root._client = HessianClientContainer.find(this.getURLPrefix());
                    }
                    this._root._remoteRoot = (NameServerRemote)this._client.createObjectStub(this.getURLPrefix());
                }
                if ((obj = this._root._remoteRoot.lookup(this._namePrefix)) instanceof NameServerRemote) {
                    this._remote = (NameServerRemote)obj;
                }
            }
            if (this._remote == null) {
                throw new NamingException(L.l("Hessian object '{0}' is not a context.", (Object)(this.getURLPrefix() + this._namePrefix)));
            }
            String[] list = this._remote.list();
            ArrayList<String> value = new ArrayList<String>();
            for (int i = 0; list != null && i < list.length; ++i) {
                value.add(list[i]);
            }
            return value;
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NamingExceptionWrapper(e);
        }
    }

    public String toString() {
        return "HessianModel[url= " + this.getURLPrefix() + ",name=" + this._namePrefix + "]";
    }
}

