/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.config.ConfigException;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.hessian.ExceptionSkeleton;
import com.caucho.ejb.hessian.HessianEjbSkeleton;
import com.caucho.ejb.hessian.HessianHandleEncoder;
import com.caucho.ejb.hessian.HessianStubFactory;
import com.caucho.ejb.hessian.NameContextSkeleton;
import com.caucho.ejb.message.MessageServer;
import com.caucho.ejb.protocol.HandleEncoder;
import com.caucho.ejb.protocol.ProtocolContainer;
import com.caucho.ejb.protocol.Skeleton;
import com.caucho.hessian.io.HessianRemoteResolver;
import com.caucho.hessian.server.HessianSkeleton;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.logging.Logger;

public class HessianProtocol
extends ProtocolContainer {
    private static final L10N L = new L10N(HessianProtocol.class);
    private static final Logger log = Logger.getLogger(HessianProtocol.class.getName());
    private HashMap<String, AbstractServer> _serverMap = new HashMap();
    private WeakHashMap<Class, HessianSkeleton> _skeletonMap = new WeakHashMap();
    private HessianRemoteResolver _resolver = new HessianStubFactory();

    public String getName() {
        return "hessian";
    }

    public void addServer(AbstractServer server) {
        log.finer(this + " add " + server);
        this._serverMap.put(server.getProtocolId(), server);
    }

    public void removeServer(AbstractServer server) {
        log.finer(this + " remove " + server);
        this._serverMap.remove(server.getProtocolId());
    }

    protected HandleEncoder createHandleEncoder(AbstractServer server, Class primaryKeyClass) throws ConfigException {
        return new HessianHandleEncoder(server, this.getURLPrefix() + server.getProtocolId(), primaryKeyClass);
    }

    public Skeleton getSkeleton(String uri, String queryString) throws Exception {
        AbstractServer server;
        String serverId = uri;
        String objectId = null;
        if (queryString != null) {
            int p = queryString.indexOf(61);
            objectId = p >= 0 ? queryString.substring(p + 1) : queryString;
        }
        if ((server = this._serverMap.get(serverId)) == null) {
            server = this.getProtocolManager().getServerByEJBName(serverId);
        }
        if (server == null) {
            ArrayList<String> children = this.getProtocolManager().getRemoteChildren(serverId);
            if (children != null && children.size() > 0) {
                return new NameContextSkeleton(this, serverId);
            }
            log.fine(this + " can't find server for " + serverId);
            return null;
        }
        if (objectId != null) {
            Object key = server.getHandleEncoder("hessian").objectIdToKey(objectId);
            Object obj = server.getRemoteObject(key);
            Class remoteApi = server.getRemoteObjectClass();
            Class homeApi = server.getRemoteHomeClass();
            HessianSkeleton skel = this.getSkeleton(remoteApi, homeApi, remoteApi);
            return new HessianEjbSkeleton(obj, skel, this._resolver);
        }
        if (server instanceof MessageServer) {
            throw new IllegalStateException(this.getClass().getName());
        }
        Class homeApi = server.getRemoteHomeClass();
        Class remoteApi = server.getRemoteObjectClass();
        if (homeApi != null) {
            Object remote = server.getRemoteObject(homeApi, "hessian");
            HessianSkeleton skel = this.getSkeleton(homeApi, homeApi, remoteApi);
            return new HessianEjbSkeleton(remote, skel, this._resolver);
        }
        if (remoteApi != null) {
            Object remote = server.getRemoteObject(remoteApi, "hessian");
            HessianSkeleton skel = this.getSkeleton(remoteApi, remoteApi, remoteApi);
            return new HessianEjbSkeleton(remote, skel, this._resolver);
        }
        return null;
    }

    public Skeleton getExceptionSkeleton() throws Exception {
        return new ExceptionSkeleton();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HessianSkeleton getSkeleton(Class api, Class homeApi, Class remoteApi) throws Exception {
        WeakHashMap<Class, HessianSkeleton> weakHashMap = this._skeletonMap;
        synchronized (weakHashMap) {
            HessianSkeleton skel = this._skeletonMap.get(api);
            if (skel == null) {
                skel = new HessianSkeleton(api);
                skel.setHomeClass(homeApi);
                skel.setObjectClass(remoteApi);
                this._skeletonMap.put(api, skel);
            }
            return skel;
        }
    }
}

