/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.ejb.hessian.HessianClientContainer;
import com.caucho.ejb.hessian.HessianWriter;
import com.caucho.hessian.io.HessianRemoteObject;
import com.caucho.hessian.io.HessianRemoteResolver;
import com.caucho.transaction.TransactionImpl;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.transaction.xa.Xid;

public abstract class HessianStub
implements HessianRemoteObject {
    private static final Logger log = Logger.getLogger(HessianStub.class.getName());
    protected String _url;
    protected transient Path _urlPath;
    protected transient HessianClientContainer _client;
    protected transient HessianRemoteResolver _resolver;

    void _init(String url, HessianClientContainer client) {
        this._url = url;
        this._urlPath = Vfs.lookup(url);
        this._hessian_setClientContainer(client);
    }

    public String getHessianURL() {
        return this._url;
    }

    void _hessian_setURL(String url) {
        this._url = url;
    }

    void _hessian_setURLPath(Path urlPath) {
        this._urlPath = urlPath;
    }

    void _hessian_setClientContainer(HessianRemoteResolver resolver) {
        this._resolver = resolver;
        if (resolver instanceof HessianClientContainer) {
            this._client = (HessianClientContainer)resolver;
        }
    }

    protected HessianWriter _hessian_openWriter() throws EJBException {
        try {
            String auth;
            ReadWritePair pair = this._urlPath.openReadWrite();
            ReadStream is = pair.getReadStream();
            WriteStream os = pair.getWriteStream();
            if (this._client != null && (auth = this._client.getBasicAuthentication()) != null) {
                os.setAttribute("Authorization", (Object)auth);
            }
            HessianWriter out = new HessianWriter((InputStream)is, (OutputStream)os);
            out.setRemoteResolver(this._resolver);
            return out;
        }
        catch (IOException e) {
            throw new EJBException((Exception)e);
        }
    }

    protected void _hessian_writeHeaders(HessianWriter out) throws IOException {
        try {
            TransactionImpl xa = (TransactionImpl)TransactionManagerImpl.getInstance().getTransaction();
            if (xa != null) {
                Xid xid = xa.getXid();
                String s = HessianStub.xidToString(xid.getGlobalTransactionId());
                out.writeHeader("xid");
                out.writeString(s);
            }
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    protected void _hessian_freeWriter(HessianWriter out) throws IOException {
        out.close();
    }

    private static String xidToString(byte[] id) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < id.length; ++i) {
            byte b = id[i];
            sb.append(HessianStub.toHex(b >> 4 & 0xF));
            sb.append(HessianStub.toHex(b & 0xF));
        }
        return sb.toString();
    }

    private static char toHex(int d) {
        if (d < 10) {
            return (char)(48 + d);
        }
        return (char)(97 + d - 10);
    }
}

