/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.ejb.hessian.MetaStub;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class HessianXAResource
implements XAResource {
    private static final Logger log = Logger.getLogger(HessianXAResource.class.getName());
    private String _url;
    private Path _path;

    public HessianXAResource(String url) {
        this._url = url;
        this._path = Vfs.lookup(url);
    }

    public boolean isSameRM(XAResource xares) {
        if (!(xares instanceof HessianXAResource)) {
            return false;
        }
        HessianXAResource rm = (HessianXAResource)xares;
        return this._url.equals(rm._url);
    }

    public void start(Xid xid, int flags) throws XAException {
    }

    public void end(Xid xid, int flags) throws XAException {
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return true;
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public int prepare(Xid xid) throws XAException {
        try {
            Object value = MetaStub.call(this._path, "prepare", HessianXAResource.xidToString(xid));
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            throw new XAException(e.toString());
        }
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        return null;
    }

    public void forget(Xid xid) throws XAException {
    }

    public void rollback(Xid xid) throws XAException {
        try {
            MetaStub.call(this._path, "rollback", HessianXAResource.xidToString(xid));
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            throw new XAException(e.toString());
        }
    }

    public void commit(Xid xid, boolean onephase) throws XAException {
        try {
            if (onephase) {
                MetaStub.call(this._path, "commitOnePhase", HessianXAResource.xidToString(xid));
            } else {
                MetaStub.call(this._path, "commit", HessianXAResource.xidToString(xid));
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            throw new XAException(e.toString());
        }
    }

    private static String xidToString(Xid xid) {
        byte[] id = xid.getGlobalTransactionId();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < id.length; ++i) {
            byte b = id[i];
            sb.append(HessianXAResource.toHex(b >> 4 & 0xF));
            sb.append(HessianXAResource.toHex(b & 0xF));
        }
        return sb.toString();
    }

    private static char toHex(int d) {
        if (d < 10) {
            return (char)(48 + d);
        }
        return (char)(97 + d - 10);
    }
}

