/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.hessian.HessianProtocol;
import com.caucho.ejb.hessian.HessianReader;
import com.caucho.ejb.hessian.HessianWriter;
import com.caucho.ejb.protocol.EjbProtocolManager;
import com.caucho.ejb.protocol.Skeleton;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.services.name.NameServerRemote;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBHome;

public class NameContextSkeleton
extends Skeleton {
    private static final Logger log = Logger.getLogger(NameContextSkeleton.class.getName());
    private HessianProtocol _protocol;
    private String _prefix;

    NameContextSkeleton(HessianProtocol protocol, String prefix) {
        this._protocol = protocol;
        this._prefix = prefix;
    }

    public void _service(InputStream is, OutputStream os) throws Exception {
        HessianReader in = new HessianReader(is);
        HessianWriter out = new HessianWriter(os);
        in.startCall();
        String method = in.getMethod();
        try {
            if (method.equals("lookup") || method.equals("lookup_string") || method.equals("lookup_1")) {
                this.executeLookup((HessianInput)in, (HessianOutput)out);
            } else if (method.equals("list")) {
                this.executeList((HessianInput)in, (HessianOutput)out);
            } else {
                this.executeUnknown(method, (HessianInput)in, (HessianOutput)out);
            }
        }
        catch (HessianProtocolException e) {
            throw e;
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            out.startReply();
            out.writeFault("ServiceException", e.getMessage(), e);
            out.completeReply();
        }
    }

    private void executeLookup(HessianInput in, HessianOutput out) throws Throwable {
        String name = in.readString();
        in.completeCall();
        while (name.startsWith("/")) {
            name = name.substring(1);
        }
        EjbProtocolManager container = this._protocol.getProtocolManager();
        AbstractServer server = container.getServerByServerId(name);
        if (server == null) {
            server = container.getServerByEJBName(name);
        }
        if (server != null) {
            EJBHome home = server.getEJBHome();
            out.startReply();
            if (home != null) {
                out.writeObject((Object)home);
            } else {
                out.writeObject(server.getRemoteObject(server.getRemoteHomeClass(), "hessian"));
            }
            out.completeReply();
        } else if (container.getRemoteChildren(name) != null) {
            String prefix;
            out.startReply();
            String serverId = this._prefix.endsWith("/") || name.startsWith("/") ? this._prefix + name : this._prefix + '/' + name;
            if (serverId.startsWith("/")) {
                serverId = serverId.substring(1);
            }
            String url = (prefix = this._protocol.getURLPrefix()).endsWith("/") ? prefix + serverId : prefix + '/' + serverId;
            out.writeRemote(NameServerRemote.class.getName(), url);
            out.completeReply();
        } else {
            out.startReply();
            out.writeNull();
            out.completeReply();
        }
    }

    private void executeList(HessianInput in, HessianOutput out) throws Throwable {
        in.completeCall();
        EjbProtocolManager container = this._protocol.getProtocolManager();
        AbstractServer server = container.getServerByEJBName(this._prefix);
        if (server != null) {
            EJBHome home = server.getEJBHome();
            out.startReply();
            out.writeNull();
            out.completeReply();
        } else {
            ArrayList<String> children = container.getRemoteChildren(this._prefix);
            if (children != null) {
                out.startReply();
                out.writeObject((Object)children.toArray(new String[children.size()]));
                out.completeReply();
            } else {
                out.startReply();
                out.writeNull();
                out.completeReply();
            }
        }
    }

    protected void executeUnknown(String method, HessianInput in, HessianOutput out) throws Exception {
        if (method.equals("_hessian_getAttribute")) {
            String key = in.readString();
            in.completeCall();
            out.startReply();
            if ("java.api.class".equals(key)) {
                out.writeString(NameServerRemote.class.getName());
            } else if ("java.home.class".equals(key)) {
                out.writeString(NameServerRemote.class.getName());
            } else if ("java.object.class".equals(key)) {
                out.writeString(NameServerRemote.class.getName());
            } else if ("home-class".equals(key)) {
                out.writeString(NameServerRemote.class.getName());
            } else if ("remote-class".equals(key)) {
                out.writeString(NameServerRemote.class.getName());
            } else {
                out.writeNull();
            }
            out.completeReply();
        } else {
            out.startReply();
            out.writeFault("NoMethod", "no such method: " + method, null);
            out.completeReply();
        }
    }
}

