/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.config.ConfigException;
import com.caucho.ejb.Version;
import com.caucho.ejb.hessian.MarshalGenerator;
import com.caucho.java.WorkDir;
import com.caucho.make.ClassDependency;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;

class StubGenerator
extends MarshalGenerator {
    private ArrayList<PersistentDependency> _dependList;

    StubGenerator() {
        this.setClassDir(WorkDir.getLocalWorkDir().lookup("ejb"));
    }

    Class createHomeStub(Class cl) throws ConfigException {
        return this.makeClient(cl, "__HessianStub", true);
    }

    Class createObjectStub(Class cl) throws ConfigException {
        return this.makeClient(cl, "__HessianStub", false);
    }

    Class createStub(Class cl) throws ConfigException {
        return this.makeClient(cl, "__HessianStub", true);
    }

    Class makeClient(Class cl, String genSuffix, boolean isHome) throws ConfigException {
        this._cl = cl;
        try {
            this.setFullClassName("_ejb." + cl.getName() + genSuffix);
            if (cl.getClassLoader() != null) {
                this.setParentLoader(cl.getClassLoader());
            }
            MergePath mergePath = new MergePath();
            if (cl.getClassLoader() != null) {
                mergePath.addClassPath(cl.getClassLoader());
            } else {
                mergePath.addClassPath(Thread.currentThread().getContextClassLoader());
            }
            this.setSearchPath((Path)mergePath);
            this._dependList = new ArrayList();
            this._dependList.add(new ClassDependency(cl));
            Class stubClass = this.preload();
            if (stubClass != null) {
                return stubClass;
            }
            this.generate();
            return this.compile();
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public void generateJava() throws IOException {
        this.generateJava(this._cl.getMethods());
    }

    private void generateJava(Method[] methods) throws IOException {
        if (EJBHome.class.isAssignableFrom(this._cl)) {
            this.printHeader("HomeStub");
        } else if (EJBObject.class.isAssignableFrom(this._cl)) {
            this.printHeader("ObjectStub");
        } else {
            this.printHeader("ObjectStub");
        }
        this.println("public String getHessianType()");
        this.println("{");
        this.println("  return \"" + this._cl.getName() + "\";");
        this.println("}");
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class<?> declaringClass = method.getDeclaringClass();
            String prefix = "";
            if (declaringClass.getName().startsWith("javax.ejb.")) {
                prefix = "_ejb_";
            }
            this.printMethod(prefix + method.getName(), method);
        }
        this.printDependList(this._dependList);
        this.printFooter();
    }

    void printHeader(String stubClassName) throws IOException {
        if (this.getPackageName() != null) {
            this.println("package " + this.getPackageName() + ";");
        }
        this.println();
        this.println("import java.io.*;");
        this.println("import java.rmi.*;");
        this.println("import com.caucho.vfs.*;");
        this.println("import com.caucho.util.*;");
        this.println("import com.caucho.ejb.hessian.*;");
        this.println("import com.caucho.hessian.io.*;");
        this.println("import " + this._cl.getName() + ";");
        this.println();
        this.println("public class " + this.getClassName() + " extends " + stubClassName);
        this.print("  implements " + this._cl.getName());
        this.println(" {");
        this.pushDepth();
    }

    void printMethod(String name, Method method) throws IOException {
        Class<?> ret = method.getReturnType();
        Class<?>[] params = method.getParameterTypes();
        this.printMethodDeclaration(name, method);
        this.println("{");
        this.pushDepth();
        this.println("HessianWriter out = _hessian_openWriter();");
        this.println("try {");
        this.pushDepth();
        String mangleName = this.mangleMethodName(method.getName(), method, false);
        this.println("out.startCall();");
        this.println("_hessian_writeHeaders(out);");
        this.println("out.writeMethod(\"" + mangleName + "\");");
        for (int i = 0; i < params.length; ++i) {
            this.printMarshalType(params[i], "_arg" + i);
        }
        this.println("HessianInput in = out.doCall();");
        if (!Void.TYPE.equals(ret)) {
            this.printClass(ret);
            this.println(" _ret;");
            this.print("_ret = ");
            this.printUnmarshalType(ret);
        } else {
            this.println("in.readNull();");
        }
        this.println("in.completeReply();");
        this.println("_hessian_freeWriter(out);");
        this.println("out = null;");
        if (!Void.TYPE.equals(ret)) {
            this.println("return _ret;");
        }
        this.popDepth();
        Class<?>[] exn = method.getExceptionTypes();
        boolean hasThrowable = false;
        boolean hasRuntimeException = false;
        block1: for (int i = 0; i < exn.length; ++i) {
            for (int j = 0; j < i; ++j) {
                if (exn[j].isAssignableFrom(exn[i])) continue block1;
            }
            if (!hasThrowable) {
                this.println("} catch (" + exn[i].getName() + " e) {");
                this.println("  throw e;");
            }
            if (exn[i].equals(Throwable.class)) {
                hasThrowable = true;
                hasRuntimeException = true;
            }
            if (exn[i].equals(Exception.class)) {
                hasRuntimeException = true;
            }
            if (!exn[i].equals(RuntimeException.class)) continue;
            hasRuntimeException = true;
        }
        if (!hasRuntimeException) {
            this.println("} catch (RuntimeException e) {");
            this.println("  throw e;");
        }
        if (!hasThrowable) {
            this.println("} catch (Throwable e) {");
            this.println("  throw new com.caucho.ejb.EJBExceptionWrapper(\"stub exception\", e);");
        }
        this.println("} finally {");
        this.println("  if (out != null) out.close();");
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    void printFooter() throws IOException {
        this.println();
        this.println("public String toString()");
        this.println("{");
        this.pushDepth();
        this.println("return \"[HessianStub " + this._cl.getName() + " \" + _urlPath + \"]\";");
        this.popDepth();
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    protected void printVersionChange() throws IOException {
        this.println("if (com.caucho.ejb.Version.getVersionId() != " + Version.getVersionId() + ")");
        this.println("  return true;");
    }
}

