/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.ejb.hessian.HessianReader;
import com.caucho.ejb.hessian.HessianWriter;
import com.caucho.ejb.protocol.Skeleton;
import com.caucho.ejb.xa.EjbTransactionManager;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.HessianProtocolException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XAResourceSkeleton
extends Skeleton {
    protected static final Logger log = Logger.getLogger(XAResourceSkeleton.class.getName());
    private EjbTransactionManager _tm;

    XAResourceSkeleton(EjbTransactionManager tm) {
        this._tm = tm;
    }

    public void _service(InputStream is, OutputStream os) throws Exception {
        HessianReader in = new HessianReader(is);
        HessianWriter out = new HessianWriter(os);
        in.startCall();
        String method = in.getMethod();
        try {
            if (method.equals("commitOnePhase") || method.equals("commitOnePhase_string") || method.equals("commitOnePhase_1")) {
                this.executeCommitOnePhase((HessianInput)in, (HessianOutput)out);
            } else if (method.equals("commit") || method.equals("commit_string") || method.equals("commit_1")) {
                this.executeCommit((HessianInput)in, (HessianOutput)out);
            } else if (method.equals("rollback") || method.equals("rollback_string") || method.equals("rollback_1")) {
                this.executeRollback((HessianInput)in, (HessianOutput)out);
            } else if (method.equals("prepare") || method.equals("prepare_string") || method.equals("prepare_1")) {
                this.executePrepare((HessianInput)in, (HessianOutput)out);
            } else {
                this.executeUnknown(method, (HessianInput)in, (HessianOutput)out);
            }
        }
        catch (HessianProtocolException e) {
            throw e;
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            out.startReply();
            out.writeFault("ServiceException", e.getMessage(), e);
            out.completeReply();
        }
    }

    private void executeCommitOnePhase(HessianInput in, HessianOutput out) throws Throwable {
        String xid = in.readString();
        in.completeCall();
        this._tm.commitTransaction(xid);
        out.startReply();
        out.writeNull();
        out.completeReply();
    }

    private void executeCommit(HessianInput in, HessianOutput out) throws Throwable {
        String xid = in.readString();
        in.completeCall();
        this._tm.commitTransaction(xid);
        out.startReply();
        out.writeNull();
        out.completeReply();
    }

    private void executePrepare(HessianInput in, HessianOutput out) throws Throwable {
        String xid = in.readString();
        in.completeCall();
        out.startReply();
        out.writeInt(0);
        out.completeReply();
    }

    private void executeRollback(HessianInput in, HessianOutput out) throws Throwable {
        String xid = in.readString();
        in.completeCall();
        this._tm.rollbackTransaction(xid);
        out.startReply();
        out.writeNull();
        out.completeReply();
    }

    protected void executeUnknown(String method, HessianInput in, HessianOutput out) throws Exception {
        if (method.equals("_hessian_getAttribute")) {
            String key = in.readString();
            in.completeCall();
            out.startReply();
            out.writeNull();
            out.completeReply();
        } else {
            out.startReply();
            out.writeFault("NoMethod", "no such method: " + method, null);
            out.completeReply();
        }
    }
}

