/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.interceptor;

import com.caucho.ejb.cfg.Interceptor;
import com.caucho.util.L10N;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.interceptor.InvocationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationContextImpl
implements InvocationContext {
    private static final L10N L = new L10N(InvocationContextImpl.class);
    private Object _target;
    private Object _home;
    private Object[] _parameters;
    private Method _method;
    private String _methodName;
    private Class[] _parameterTypes;
    private HashMap<String, Object> _contextData;
    private Object[] _context;
    private int _curr;
    private Object[] _interceptors;
    private Method[] _methods;
    private boolean _hasCalledTargetMethod;

    public InvocationContextImpl(Object target, Object home, String methodName, Class[] parameterTypes, Object[] interceptors, Method[] methods) {
        this._target = target;
        this._home = home;
        this._methodName = methodName;
        this._parameterTypes = parameterTypes;
        this._interceptors = interceptors;
        this._methods = methods;
        this._context = new Object[]{this};
    }

    public Object getHome() {
        return this._home;
    }

    public Object getTarget() {
        return this._target;
    }

    public Method getMethod() {
        if (this._method == null) {
            if (this._methodName == null) {
                return null;
            }
            Class<?> cl = this._target.getClass();
            try {
                this._method = cl.getMethod(this._methodName, this._parameterTypes);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        return this._method;
    }

    public Object[] getParameters() throws IllegalStateException {
        return this._parameters;
    }

    public void setParameters(Object[] parameters) throws IllegalStateException {
        this._parameters = parameters;
    }

    public Map<String, Object> getContextData() {
        if (this._contextData == null) {
            this._contextData = new HashMap();
        }
        return this._contextData;
    }

    public Object proceed() throws Exception {
        try {
            if (this.hasNextInterceptor()) {
                Object interceptor = this.nextInterceptor();
                return InvocationContextImpl.invokeMethod(this.getCurrentMethod(), interceptor, this._context);
            }
            if (!this.hasCalledTargetMethod()) {
                return InvocationContextImpl.invokeMethod(this.getMethod(), this.getTarget(), this.getParameters());
            }
        }
        catch (InvocationTargetException e) {
            throw (Exception)e.getCause();
        }
        catch (Exception e) {
            throw e;
        }
        return null;
    }

    public static Object invokeMethod(Method method, Object obj, Object[] params) throws Exception {
        if (method == null) {
            return null;
        }
        Interceptor.makeAccessible(method);
        return method.invoke(obj, params);
    }

    private boolean hasCalledTargetMethod() {
        return this._hasCalledTargetMethod;
    }

    private void setHasCalledTargetMethod(boolean b) {
        this._hasCalledTargetMethod = b;
    }

    private boolean hasNextInterceptor() {
        return this._curr < this._interceptors.length;
    }

    private Object nextInterceptor() {
        return this._interceptors[this._curr++];
    }

    private Method getCurrentMethod() {
        return this._methods[this._curr - 1];
    }
}

