/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.manager;

import com.caucho.amber.manager.AmberContainer;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.config.ConfigException;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.cfg.EjbConfigManager;
import com.caucho.ejb.cfg.EjbRootConfig;
import com.caucho.ejb.entity.EntityCache;
import com.caucho.ejb.protocol.EjbProtocolManager;
import com.caucho.ejb.xa.EjbTransactionManager;
import com.caucho.java.WorkDir;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.loader.SimpleLoader;
import com.caucho.loader.enhancer.ScanListener;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ConnectionFactory;

public class EjbContainer
implements ScanListener,
EnvironmentListener {
    private static final L10N L = new L10N(EjbContainer.class);
    private static final Logger log = Logger.getLogger(EjbContainer.class.getName());
    private static final EnvironmentLocal<EjbContainer> _localContainer = new EnvironmentLocal();
    private final EnvironmentClassLoader _classLoader;
    private final ClassLoader _tempClassLoader;
    private final EjbContainer _parentContainer;
    private final EjbConfigManager _configManager;
    private final EjbTransactionManager _transactionManager;
    private final EjbProtocolManager _protocolManager;
    private final EntityCache _entityCache;
    private AmberPersistenceUnit _ejbPersistenceUnit;
    private HashSet<String> _ejbUrls = new HashSet();
    private boolean _isAutoCompile = true;
    private Path _workDir;
    private ConnectionFactory _jmsConnectionFactory;
    private int _messageConsumerMax = 5;
    private ArrayList<AbstractServer> _serverList = new ArrayList();

    private EjbContainer(ClassLoader loader) {
        this._parentContainer = _localContainer.get(loader);
        this._classLoader = Environment.getEnvironmentClassLoader(loader);
        this._tempClassLoader = this._classLoader.getNewTempClassLoader();
        _localContainer.set(this, this._classLoader);
        if (this._parentContainer != null) {
            this.copyContainerDefaults(this._parentContainer);
        }
        this._transactionManager = new EjbTransactionManager(this);
        this._protocolManager = new EjbProtocolManager(this);
        this._configManager = new EjbConfigManager(this);
        this._entityCache = new EntityCache();
        this._workDir = WorkDir.getLocalWorkDir().lookup("ejb");
        this._classLoader.addScanListener(this);
        Environment.addEnvironmentListener(this);
    }

    public static EjbContainer create() {
        return EjbContainer.create(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EjbContainer create(ClassLoader loader) {
        EnvironmentLocal<EjbContainer> environmentLocal = _localContainer;
        synchronized (environmentLocal) {
            EjbContainer container = _localContainer.getLevel(loader);
            if (container == null) {
                container = new EjbContainer(loader);
                _localContainer.set(container, loader);
            }
            return container;
        }
    }

    public static EjbContainer getCurrent() {
        return EjbContainer.getCurrent(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EjbContainer getCurrent(ClassLoader loader) {
        EnvironmentLocal<EjbContainer> environmentLocal = _localContainer;
        synchronized (environmentLocal) {
            return _localContainer.get(loader);
        }
    }

    public EnvironmentClassLoader getClassLoader() {
        return this._classLoader;
    }

    public ClassLoader getIntrospectionClassLoader() {
        return this._tempClassLoader;
    }

    public EjbConfigManager getConfigManager() {
        return this._configManager;
    }

    public EjbContainer getParent() {
        return this._parentContainer;
    }

    public EjbProtocolManager getProtocolManager() {
        return this._protocolManager;
    }

    public EjbTransactionManager getTransactionManager() {
        return this._transactionManager;
    }

    public EntityCache getEntityCache() {
        return this._entityCache;
    }

    public AmberPersistenceUnit createEjbPersistenceUnit() {
        if (this._ejbPersistenceUnit == null) {
            try {
                AmberContainer amber = AmberContainer.create(this._classLoader);
                this._ejbPersistenceUnit = amber.createPersistenceUnit("resin-ejb");
                this._ejbPersistenceUnit.setBytecodeGenerator(false);
                DynamicClassLoader loader = SimpleLoader.create(this.getWorkDir());
                this._ejbPersistenceUnit.setEnhancedLoader(loader);
                this._ejbPersistenceUnit.initLoaders();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw ConfigException.create((Throwable)e);
            }
        }
        return this._ejbPersistenceUnit;
    }

    public void setAutoCompile(boolean isAutoCompile) {
        this._isAutoCompile = isAutoCompile;
    }

    public boolean isAutoCompile() {
        return this._isAutoCompile;
    }

    public void setWorkDir(Path workDir) {
        this._workDir = workDir;
    }

    public Path getWorkDir() {
        return this._workDir;
    }

    public void setJmsConnectionFactory(ConnectionFactory factory) {
        this._jmsConnectionFactory = factory;
    }

    public ConnectionFactory getJmsConnectionFactory() {
        return this._jmsConnectionFactory;
    }

    public void setMessageConsumerMax(int consumerMax) {
        this._messageConsumerMax = consumerMax;
    }

    public int getMessageConsumerMax() {
        return this._messageConsumerMax;
    }

    private void copyContainerDefaults(EjbContainer parent) {
        this._isAutoCompile = parent._isAutoCompile;
        this._jmsConnectionFactory = parent._jmsConnectionFactory;
        this._messageConsumerMax = parent._messageConsumerMax;
    }

    public void addServer(AbstractServer server) {
        this._serverList.add(server);
        this.getProtocolManager().addServer(server);
    }

    public AbstractServer getServer(String ejbName) {
        for (AbstractServer server : this._serverList) {
            if (!server.getEJBName().equals(ejbName)) continue;
            return server;
        }
        return null;
    }

    public AbstractServer getServer(Path path, String ejbName) {
        String mappedName = path.getFullPath() + "#" + ejbName;
        for (AbstractServer server : this._serverList) {
            if (!mappedName.equals(server.getId())) continue;
            return server;
        }
        return null;
    }

    public String getClientRemoteConfig() {
        StringBuilder sb = new StringBuilder();
        sb.append("<!-- test references -->");
        for (AbstractServer server : this._serverList) {
            server.addClientRemoteConfig(sb);
        }
        return sb.toString();
    }

    public void addRoot(Path root) {
        Path ejbJar;
        if (root.getURL().endsWith(".jar")) {
            root = JarPath.create(root);
        }
        if ((ejbJar = root.lookup("META-INF/ejb-jar.xml")).canRead()) {
            this.getConfigManager().addEjbPath(ejbJar);
        }
        this._ejbUrls.add(root.getURL());
    }

    public boolean isRootScannable(Path root) {
        if (!this._ejbUrls.contains(root.getURL()) && !root.lookup("META-INF/ejb-jar.xml").canRead()) {
            return false;
        }
        EjbRootConfig context = this._configManager.createRootConfig(root);
        if (context.isScanComplete()) {
            return false;
        }
        context.setScanComplete(true);
        return true;
    }

    public boolean isScanMatch(CharBuffer annotationName) {
        if (annotationName.matches("javax.ejb.Stateless")) {
            return true;
        }
        if (annotationName.matches("javax.ejb.Stateful")) {
            return true;
        }
        return annotationName.matches("javax.ejb.MessageDriven");
    }

    public void classMatchEvent(EnvironmentClassLoader loader, Path root, String className) {
        EjbRootConfig config = this._configManager.createRootConfig(root);
        config.addClassName(className);
    }

    public void init() {
    }

    private void config() {
        this._configManager.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws ConfigException {
        try {
            AmberContainer.create().start();
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            for (AbstractServer server : this._serverList) {
                Object var6_7;
                try {
                    thread.setContextClassLoader(server.getClassLoader());
                    server.start();
                    var6_7 = null;
                    thread.setContextClassLoader(oldLoader);
                }
                catch (Throwable throwable) {
                    var6_7 = null;
                    thread.setContextClassLoader(oldLoader);
                    throw throwable;
                }
            }
            AmberContainer.create().start();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public void destroy() {
        try {
            ArrayList<AbstractServer> servers = new ArrayList<AbstractServer>(this._serverList);
            this._serverList.clear();
            Collections.sort(servers, new ServerCmp());
            for (AbstractServer server : servers) {
                try {
                    this.getProtocolManager().removeServer(server);
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            for (AbstractServer server : servers) {
                try {
                    server.destroy();
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void environmentBind(EnvironmentClassLoader loader) {
        this.config();
    }

    public void environmentStart(EnvironmentClassLoader loader) {
        this.start();
    }

    public void environmentStop(EnvironmentClassLoader loader) {
        this.destroy();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._classLoader + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ServerCmp
    implements Comparator<AbstractServer> {
        ServerCmp() {
        }

        @Override
        public int compare(AbstractServer a, AbstractServer b) {
            return a.getEJBName().compareTo(b.getEJBName());
        }
    }
}

