/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.message;

import com.caucho.config.ConfigException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XASession;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

public class JmsResourceAdapter
implements ResourceAdapter {
    private static final Logger log = Logger.getLogger(JmsResourceAdapter.class.getName());
    private static final Method _onMessage;
    private final String _ejbName;
    private final ConnectionFactory _connectionFactory;
    private final Destination _destination;
    private int _consumerMax = 5;
    private int _acknowledgeMode = 1;
    private String _subscriptionName;
    private String _selector;
    private Connection _connection;
    private MessageEndpointFactory _endpointFactory;
    private ArrayList<Consumer> _consumers;

    public JmsResourceAdapter(String ejbName, ConnectionFactory factory, Destination destination) {
        assert (factory != null);
        assert (destination != null);
        this._ejbName = ejbName;
        this._connectionFactory = factory;
        this._destination = destination;
    }

    public void setMessageSelector(String selector) {
        this._selector = selector;
    }

    public void setSubscriptionName(String subscriptionName) {
        this._subscriptionName = subscriptionName;
    }

    public void setConsumerMax(int consumerMax) {
        this._consumerMax = consumerMax;
    }

    public void setAcknowledgeMode(int acknowledgeMode) {
        this._acknowledgeMode = acknowledgeMode;
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
    }

    public void stop() throws ResourceAdapterInternalException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws NotSupportedException {
        JmsResourceAdapter jmsResourceAdapter = this;
        synchronized (jmsResourceAdapter) {
            if (this._consumers != null) {
                throw new IllegalStateException();
            }
            this._consumers = new ArrayList();
        }
        try {
            Connection connection;
            assert (this._connectionFactory != null);
            assert (this._destination != null);
            assert (this._consumerMax > 0);
            this._endpointFactory = endpointFactory;
            this._connection = connection = this._connectionFactory.createConnection();
            if (this._destination instanceof Topic) {
                this._consumerMax = 1;
            }
            for (int i = 0; i < this._consumerMax; ++i) {
                Consumer consumer = new Consumer(this._connection, this._destination);
                this._consumers.add(consumer);
                consumer.start();
            }
            this._connection.start();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
        try {
            ArrayList<Consumer> consumers = this._consumers;
            this._consumers = null;
            if (consumers != null) {
                consumers = new ArrayList<Consumer>(consumers);
                for (Consumer consumer : consumers) {
                    consumer.destroy();
                }
            }
            if (this._connection != null) {
                this._connection.close();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        return new XAResource[0];
    }

    public String toString() {
        return this.getClass().getName() + "[" + this._ejbName + "," + this._destination + "]";
    }

    static {
        try {
            _onMessage = MessageListener.class.getMethod("onMessage", Message.class);
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    class Consumer {
        private Session _session;
        private XAResource _xaResource;
        private MessageConsumer _consumer;
        private MessageEndpoint _endpoint;
        private MessageListener _listener;

        Consumer(Connection conn, Destination destination) throws Exception {
            boolean transacted = true;
            this._session = conn.createSession(transacted, JmsResourceAdapter.this._acknowledgeMode);
            if (this._session instanceof XASession) {
                this._xaResource = ((XASession)this._session).getXAResource();
            }
            this._endpoint = JmsResourceAdapter.this._endpointFactory.createEndpoint(this._xaResource);
            this._listener = (MessageListener)this._endpoint;
        }

        void start() throws Exception {
            if (JmsResourceAdapter.this._subscriptionName != null) {
                Topic topic = (Topic)JmsResourceAdapter.this._destination;
                this._consumer = this._session.createDurableSubscriber(topic, JmsResourceAdapter.this._subscriptionName, JmsResourceAdapter.this._selector, true);
            } else {
                this._consumer = this._session.createConsumer(JmsResourceAdapter.this._destination, JmsResourceAdapter.this._selector);
            }
            this._consumer.setMessageListener(this._listener);
        }

        public Session getSession() throws JMSException {
            return this._session;
        }

        private void destroy() throws JMSException {
            this._endpoint.release();
        }
    }
}

