/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.message;

import com.caucho.config.ConfigContext;
import com.caucho.ejb.AbstractContext;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.manager.EjbContainer;
import com.caucho.ejb.message.CauchoMessageEndpoint;
import com.caucho.ejb.message.MessageDrivenContextImpl;
import com.caucho.util.L10N;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.MessageDrivenContext;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAResource;

public class MessageServer
extends AbstractServer
implements MessageEndpointFactory {
    private static final L10N L = new L10N(MessageServer.class);
    protected static final Logger log = Logger.getLogger(MessageServer.class.getName());
    private ResourceAdapter _ra;
    private ActivationSpec _activationSpec;
    private MessageDrivenContext _context;
    private Method _ejbCreate;

    public MessageServer(EjbContainer ejbContainer) {
        super(ejbContainer);
        WebBeansContainer webBeans = WebBeansContainer.create();
        UserTransaction ut = webBeans.getObject(UserTransaction.class, new Annotation[0]);
        this._context = new MessageDrivenContextImpl(this, ut);
    }

    protected String getType() {
        return "message:";
    }

    public void setActivationSpec(ActivationSpec activationSpec) {
        this._activationSpec = activationSpec;
    }

    public void setResourceAdapter(ResourceAdapter ra) {
        this._ra = ra;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._loader);
            super.init();
            if (this._activationSpec == null) {
                throw this.error(L.l("ActivationSpec is missing from message-driven bean '{0}'.", (Object)this.getEJBName()));
            }
            if (this._ra == null) {
                throw this.error(L.l("ResourceAdapter is missing from message-driven bean '{0}'.", (Object)this.getEJBName()));
            }
            try {
                Class beanClass = this.getBeanSkelClass();
                this._ejbCreate = beanClass.getMethod("ejbCreate", new Class[0]);
            }
            catch (Exception e) {
                log.log(Level.FINEST, e.toString(), e);
            }
            Object var5_5 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    protected void bindContext() {
        WebBeansContainer webBeans = WebBeansContainer.create();
        webBeans.addSingleton(this._context);
    }

    public boolean start() throws Exception {
        if (!super.start()) {
            return false;
        }
        this._ra.endpointActivation((MessageEndpointFactory)this, this._activationSpec);
        return true;
    }

    public MessageDrivenContext getMessageContext() {
        return this._context;
    }

    void generate() throws Exception {
    }

    public AbstractContext getContext(Object obj, boolean foo) {
        throw new UnsupportedOperationException();
    }

    public MessageEndpoint createEndpoint(XAResource xaResource) throws UnavailableException {
        try {
            Object listener = this.createMessageListener();
            ((CauchoMessageEndpoint)listener).__caucho_setXAResource(xaResource);
            return (MessageEndpoint)listener;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() != null) {
                throw new UnavailableException(e.getCause());
            }
            throw new UnavailableException((Throwable)e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object createMessageListener() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            Class beanClass = this.getBeanSkelClass();
            Constructor ctor = beanClass.getConstructor(MessageServer.class);
            Object listener = ctor.newInstance(this);
            this.initInstance(listener, new ConfigContext());
            if (this._ejbCreate != null) {
                this._ejbCreate.invoke(listener, new Object[0]);
            }
            Object t = listener;
            Object var8_7 = null;
            thread.setContextClassLoader(oldLoader);
            return t;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public void destroy() {
        this._ra.endpointDeactivation((MessageEndpointFactory)this, this._activationSpec);
    }

    public Object getRemoteObject(Class api, String protocol) {
        return null;
    }

    public Object getLocalObject(Class api) {
        return null;
    }

    public Object getLocalProxy(Class api) {
        return null;
    }
}

