/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.metadata;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ContainerProgram;
import com.caucho.ejb.manager.EjbContainer;
import com.caucho.loader.EnvironmentBean;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

public class Bean
implements EnvironmentBean {
    private static final L10N L = new L10N(Bean.class);
    private static final Logger log = Log.open(Bean.class);
    private EjbContainer _ejbContainer;
    private ClassLoader _tempClassLoader;
    private Class _type;
    private String _name;
    private ArrayList<ContainerProgram> _initList = new ArrayList();

    public Bean(EjbContainer ejbContainer) {
        this._ejbContainer = ejbContainer;
        this._tempClassLoader = ejbContainer.getIntrospectionClassLoader();
    }

    public ClassLoader getClassLoader() {
        return this._tempClassLoader;
    }

    protected String getEJBModuleName() {
        return "introspected";
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setType(Class type) throws ConfigException {
        this._type = type;
        this._ejbContainer.getConfigManager().addIntrospectableClass(this._type.getName());
    }

    public void addInit(ContainerProgram init) {
        this._initList.add(init);
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (this._type == null) {
            throw new ConfigException(L.l("type is a required attribute of <bean>"));
        }
    }
}

