/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.protocol;

import com.caucho.ejb.AbstractServer;
import com.caucho.iiop.IiopRemoteService;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.NoSuchEJBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbIiopRemoteService
extends IiopRemoteService {
    private static final Logger log = Logger.getLogger(EjbIiopRemoteService.class.getName());
    private AbstractServer _server;
    private Class _remoteInterface;
    private boolean _isEJB3;

    public EjbIiopRemoteService(AbstractServer server) {
        this._server = server;
    }

    public EjbIiopRemoteService(AbstractServer server, Class remoteInterface) {
        this._server = server;
        this._remoteInterface = remoteInterface;
    }

    @Override
    public boolean isEJB3() {
        return this._isEJB3;
    }

    public void setEJB3(boolean isEJB3) {
        this._isEJB3 = isEJB3;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._server.getClassLoader();
    }

    @Override
    public ArrayList<Class> getHomeAPI() {
        if (this._server.getRemoteHomeClass() != null) {
            ArrayList<Class> list = new ArrayList<Class>();
            list.add(this._server.getRemoteHomeClass());
            return list;
        }
        if (this.getRemoteInterface() != null) {
            ArrayList<Class> list = new ArrayList<Class>();
            list.add(this.getRemoteInterface());
            return list;
        }
        return this._server.getRemoteApiList();
    }

    @Override
    public ArrayList<Class> getObjectAPI() {
        if (!this._isEJB3 && this._server.getRemote21() != null) {
            ArrayList<Class> list = new ArrayList<Class>();
            list.add(this._server.getRemote21());
            return list;
        }
        return this._server.getRemoteApiList();
    }

    @Override
    public Class getRemoteInterface() {
        return this._remoteInterface;
    }

    @Override
    public Object getHome() {
        Object obj = this._server.getRemoteObject(this._server.getRemoteHomeClass(), "iiop");
        if (obj != null) {
            return obj;
        }
        return this._server.getRemoteObject(this._remoteInterface, "iiop");
    }

    @Override
    public Object getObject(String local) throws NoSuchObjectException {
        try {
            return this._server.getRemoteObject(local);
        }
        catch (NoSuchEJBException e) {
            if (this._remoteInterface == null && !this._isEJB3 || this._remoteInterface != null && Remote.class.isAssignableFrom(this._remoteInterface)) {
                throw new NoSuchObjectException("no matching object: " + local);
            }
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public String toString() {
        return "EjbIiopRemoteService[" + this._server + "]";
    }
}

