/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.protocol;

import com.caucho.config.ConfigException;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.manager.EjbContainer;
import com.caucho.ejb.protocol.AbstractHandle;
import com.caucho.ejb.protocol.HandleEncoder;
import com.caucho.ejb.protocol.IiopProtocolContainer;
import com.caucho.ejb.protocol.ProtocolContainer;
import com.caucho.ejb.protocol.ServerLocalProxy;
import com.caucho.ejb.protocol.ServerRemoteProxy;
import com.caucho.naming.Jndi;
import com.caucho.server.e_app.EnterpriseApplication;
import com.caucho.util.L10N;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbProtocolManager {
    private static final L10N L = new L10N(EjbProtocolManager.class);
    protected static final Logger log = Logger.getLogger(EjbProtocolManager.class.getName());
    private static ThreadLocal<String> _protocolLocal = new ThreadLocal();
    private static Hashtable<String, WeakReference<AbstractServer>> _staticServerMap = new Hashtable();
    private final EjbContainer _ejbContainer;
    private final ClassLoader _loader;
    private String _localJndiPrefix;
    private String _remoteJndiPrefix;
    private String _jndiPrefix;
    private HashMap<String, AbstractServer> _serverMap = new HashMap();
    protected ProtocolContainer _protocolContainer;
    protected HashMap<String, ProtocolContainer> _protocolMap = new HashMap();

    public EjbProtocolManager(EjbContainer ejbContainer) throws ConfigException {
        EjbContainer parent;
        this._ejbContainer = ejbContainer;
        this._loader = this._ejbContainer.getClassLoader();
        IiopProtocolContainer iiop = IiopProtocolContainer.createProtocolContainer();
        if (iiop != null) {
            this._protocolMap.put("iiop", iiop);
        }
        if ((parent = ejbContainer.getParent()) != null) {
            this._localJndiPrefix = parent.getProtocolManager().getLocalJndiPrefix();
            this._remoteJndiPrefix = parent.getProtocolManager().getRemoteJndiPrefix();
            this._jndiPrefix = parent.getProtocolManager().getJndiPrefix();
        }
    }

    public void setJndiPrefix(String name) {
        this._jndiPrefix = name;
    }

    public String getJndiPrefix() {
        return this._jndiPrefix;
    }

    public void setLocalJndiPrefix(String name) {
        this._localJndiPrefix = name;
    }

    public String getLocalJndiPrefix() {
        return this._localJndiPrefix;
    }

    public void setRemoteJndiPrefix(String name) {
        this._remoteJndiPrefix = name;
    }

    public String getRemoteJndiPrefix() {
        return this._remoteJndiPrefix;
    }

    public EjbContainer getEjbContainer() {
        return this._ejbContainer;
    }

    public void init() throws NamingException {
    }

    public static String getThreadProtocol() {
        return _protocolLocal.get();
    }

    public static String setThreadProtocol(String protocol) {
        String oldProtocol = _protocolLocal.get();
        _protocolLocal.set(protocol);
        return oldProtocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProtocolContainer(ProtocolContainer protocol) {
        this._protocolContainer = protocol;
        HashMap<String, ProtocolContainer> hashMap = this._protocolMap;
        synchronized (hashMap) {
            this._protocolMap.put(protocol.getName(), protocol);
        }
        this.addProtocolServers(protocol);
    }

    public void addProtocolContainer(ProtocolContainer protocol) {
        if (this._protocolContainer == null) {
            this._protocolContainer = protocol;
        }
        this.addProtocolContainer(protocol.getName(), protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProtocolContainer(ProtocolContainer protocol) {
        if (this._protocolContainer == protocol) {
            this._protocolContainer = null;
        }
        HashMap<String, ProtocolContainer> hashMap = this._protocolMap;
        synchronized (hashMap) {
            this._protocolMap.remove(protocol.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProtocolContainer(String name, ProtocolContainer protocol) {
        HashMap<String, ProtocolContainer> hashMap = this._protocolMap;
        synchronized (hashMap) {
            if (this._protocolMap.get(name) == null) {
                this._protocolMap.put(name, protocol);
            }
        }
        this.addProtocolServers(protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtocolContainer getProtocol(String name) {
        HashMap<String, ProtocolContainer> hashMap = this._protocolMap;
        synchronized (hashMap) {
            return this._protocolMap.get(name);
        }
    }

    private void addProtocolServers(ProtocolContainer protocol) {
        for (AbstractServer server : this._serverMap.values()) {
            protocol.addServer(server);
        }
    }

    public static AbstractServer getJVMServer(String serverId) {
        WeakReference<AbstractServer> serverRef = _staticServerMap.get(serverId);
        return serverRef != null ? (AbstractServer)serverRef.get() : null;
    }

    public void addServer(AbstractServer server) {
        this._serverMap.put(server.getProtocolId(), server);
        for (ProtocolContainer protocol : this._protocolMap.values()) {
            protocol.addServer(server);
        }
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            try {
                String jndiName;
                Class api;
                Thread.currentThread().setContextClassLoader(this._loader);
                String ejbName = server.getEJBName();
                String mappedName = server.getMappedName();
                this.bindDefaultJndi(this._jndiPrefix, server);
                if (this._localJndiPrefix != null) {
                    Object localHome = server.getLocalObject(server.getLocalHomeClass());
                    api = null;
                    jndiName = Jndi.getFullName(this._localJndiPrefix + "/" + ejbName);
                    if (localHome != null) {
                        Jndi.bindDeep(jndiName, localHome);
                    } else {
                        if (server.getLocalApiList().size() == 1) {
                            api = server.getLocalApiList().get(0);
                            this.bindServer(jndiName, server, api);
                        }
                        for (Class localApi : server.getLocalApiList()) {
                            this.bindServer(jndiName + '#' + localApi.getName(), server, localApi);
                        }
                    }
                }
                if (this._remoteJndiPrefix != null) {
                    Object remoteHome = server.getRemoteObject(server.getRemoteHomeClass(), null);
                    api = null;
                    jndiName = Jndi.getFullName(this._remoteJndiPrefix + "/" + ejbName);
                    if (remoteHome != null) {
                        Jndi.bindDeep(jndiName, remoteHome);
                    } else {
                        if (server.getRemoteApiList().size() == 1) {
                            api = server.getRemoteApiList().get(0);
                            this.bindRemoteServer(jndiName, server, api);
                        }
                        for (Class remoteApi : server.getRemoteApiList()) {
                            this.bindRemoteServer(jndiName + '#' + remoteApi.getName(), server, remoteApi);
                        }
                    }
                }
                Object var12_13 = null;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw ConfigException.create((Throwable)e);
            }
            Thread.currentThread().setContextClassLoader(loader);
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            Thread.currentThread().setContextClassLoader(loader);
            throw throwable;
        }
    }

    private void bindDefaultJndi(String prefix, AbstractServer server) {
        try {
            EnterpriseApplication eApp = EnterpriseApplication.getLocal();
            if (prefix == null) {
                prefix = "";
            } else if (!prefix.endsWith("/")) {
                prefix = prefix + "/";
            }
            if (eApp != null) {
                prefix = prefix + eApp.getName() + "/";
            }
            prefix = prefix + server.getEJBName();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            ArrayList<Class> apiList = server.getLocalApiList();
            if (apiList != null && apiList.size() > 0) {
                String jndiName = prefix + "/local";
                Jndi.bindDeep(jndiName, new ServerLocalProxy(server, apiList.get(0)));
                log.fine(server + " local binding to '" + jndiName + "' " + loader);
            }
            Object localHome = null;
            if (server.getLocalHomeClass() != null) {
                localHome = server.getLocalObject(server.getLocalHomeClass());
            }
            if (localHome != null) {
                String jndiName = prefix + "/local-home";
                Jndi.bindDeep(jndiName, localHome);
                log.fine(server + " local-home binding to '" + jndiName + "' " + loader);
            }
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindServer(String jndiName, AbstractServer server, Class api) throws NamingException {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this._loader);
            if (log.isLoggable(Level.FINER)) {
                log.finer(server + " binding to " + jndiName);
            }
            Jndi.bindDeep(jndiName, server.getLocalProxy(api));
            Object var7_6 = null;
            Thread.currentThread().setContextClassLoader(loader);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Thread.currentThread().setContextClassLoader(loader);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindRemoteServer(String jndiName, AbstractServer server, Class api) throws NamingException {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this._loader);
            Jndi.bindDeep(jndiName, new ServerRemoteProxy(server, api));
            Object var7_6 = null;
            Thread.currentThread().setContextClassLoader(loader);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Thread.currentThread().setContextClassLoader(loader);
            throw throwable;
        }
    }

    public void removeServer(AbstractServer server) throws NamingException {
        for (ProtocolContainer protocol : this._protocolMap.values()) {
            protocol.removeServer(server);
        }
    }

    public AbstractServer getServerByEJBName(String ejbName) {
        if (!ejbName.startsWith("/")) {
            ejbName = "/" + ejbName;
        }
        return this._serverMap.get(ejbName);
    }

    public AbstractServer getServerByServerId(String protocolId) {
        for (AbstractServer server : this._serverMap.values()) {
            if (!protocolId.equals(server.getProtocolId())) continue;
            return server;
        }
        return null;
    }

    public Iterator getLocalNames() {
        return this._serverMap.keySet().iterator();
    }

    public ArrayList<String> getLocalChildren(String ejbName) {
        if (!ejbName.startsWith("/")) {
            ejbName = "/" + ejbName;
        }
        if (!ejbName.endsWith("/")) {
            ejbName = ejbName + "/";
        }
        ArrayList<String> children = new ArrayList<String>();
        for (String name : this._serverMap.keySet()) {
            int prefixLength;
            int p;
            AbstractServer server = this._serverMap.get(name);
            if (server.getLocalObject(null) == null || !name.startsWith(ejbName) || children.contains(name = (p = name.indexOf(47, prefixLength = ejbName.length())) > 0 ? name.substring(prefixLength, p) : name.substring(prefixLength))) continue;
            children.add(name);
        }
        return children;
    }

    public ArrayList<String> getRemoteChildren(String ejbName) {
        if (!ejbName.startsWith("/")) {
            ejbName = "/" + ejbName;
        }
        ArrayList<String> children = new ArrayList<String>();
        for (String name : this._serverMap.keySet()) {
            int prefixLength;
            int p;
            AbstractServer server = this._serverMap.get(name);
            if (server.getRemoteObjectClass() == null || !name.startsWith(ejbName) || children.contains(name = (p = name.indexOf(47, prefixLength = ejbName.length())) > 0 ? name.substring(prefixLength, p) : name.substring(prefixLength))) continue;
            children.add(name);
        }
        if (children.size() == 0) {
            return null;
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandleEncoder createHandleEncoder(AbstractServer server, Class primaryKeyClass, String protocolName) throws ConfigException {
        ProtocolContainer protocol = null;
        HashMap<String, ProtocolContainer> hashMap = this._protocolMap;
        synchronized (hashMap) {
            protocol = this._protocolMap.get(protocolName);
        }
        if (protocol != null) {
            return protocol.createHandleEncoder(server, primaryKeyClass);
        }
        if (this._protocolContainer != null) {
            return this._protocolContainer.createHandleEncoder(server, primaryKeyClass);
        }
        return new HandleEncoder(server, server.getProtocolId());
    }

    protected HandleEncoder createHandleEncoder(AbstractServer server, Class primaryKeyClass) throws ConfigException {
        if (this._protocolContainer != null) {
            return this._protocolContainer.createHandleEncoder(server, primaryKeyClass);
        }
        return new HandleEncoder(server, server.getProtocolId());
    }

    protected void remove(AbstractHandle handle) {
    }

    public void destroy() {
    }
}

