/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.protocol;

import com.caucho.config.ConfigException;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.protocol.EjbIiopRemoteService;
import com.caucho.ejb.protocol.HandleEncoder;
import com.caucho.ejb.protocol.ProtocolContainer;
import com.caucho.ejb.protocol.Skeleton;
import com.caucho.iiop.IiopContext;
import com.caucho.iiop.IiopRemoteService;
import com.caucho.server.e_app.EnterpriseApplication;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.ejb.EJBHome;

public class IiopProtocolContainer
extends ProtocolContainer {
    private static final Logger log = Logger.getLogger(IiopProtocolContainer.class.getName());
    private static final L10N L = new L10N(IiopProtocolContainer.class);
    private IiopContext _context;

    private IiopProtocolContainer(IiopContext context) {
        this._context = context;
    }

    public static IiopProtocolContainer createProtocolContainer() {
        IiopContext context = IiopContext.getLocalContext();
        if (context != null) {
            return new IiopProtocolContainer(context);
        }
        return null;
    }

    public static EJBHome findRemoteEJB(String ejbName) {
        IiopRemoteService service;
        IiopContext context = IiopContext.getLocalContext();
        if (context == null) {
            return null;
        }
        if (!ejbName.startsWith("/")) {
            ejbName = "/" + ejbName;
        }
        if ((service = context.getService(ejbName)) != null) {
            return (EJBHome)service.getHome();
        }
        return null;
    }

    public String getName() {
        return "iiop";
    }

    public void addServer(AbstractServer server) {
        Object obj = null;
        Object remoteInterface = null;
        Class homeApi = server.getRemoteHomeClass();
        Class remoteApi = server.getRemoteObjectClass();
        Class api = null;
        if (homeApi != null) {
            obj = server.getRemoteObject(homeApi, "iiop");
            api = homeApi;
        } else if (remoteApi != null) {
            obj = server.getRemoteObject(remoteApi, "iiop");
            api = remoteApi;
        }
        if (obj == null) {
            return;
        }
        String name = this.getName(server);
        log.fine("iiop: add server " + name);
        EjbIiopRemoteService service = new EjbIiopRemoteService(server, api);
        this._context.setService(name, service);
        String remoteJndiName = name;
        for (Class cl : server.getRemoteApiList()) {
            String s = cl.getName().replace(".", "_");
            name = remoteJndiName + "#" + s;
            log.fine("iiop: add server " + name);
            service = new EjbIiopRemoteService(server, cl);
            boolean isEJB3 = true;
            if (server.getRemote21() != null && server.getRemote21().getName().equals(cl.getName())) {
                isEJB3 = false;
            }
            service.setEJB3(isEJB3);
            this._context.setService(name, service);
        }
    }

    public void removeServer(AbstractServer server) {
        String name = this.getName(server);
        this._context.removeService(name);
    }

    protected HandleEncoder createHandleEncoder(AbstractServer server, Class primaryKeyClass) throws ConfigException {
        String name = this.getName(server);
        if (this._urlPrefix != null) {
            return new HandleEncoder(server, this._urlPrefix + name);
        }
        return new HandleEncoder(server, name);
    }

    public Skeleton getSkeleton(String uri, String queryString) throws Exception {
        throw new UnsupportedOperationException();
    }

    private String getName(AbstractServer server) {
        EnterpriseApplication eApp;
        String name = server.getProtocolId();
        if (name == null) {
            name = server.getEJBName();
        }
        if (!(name = name.replace('.', '_')).startsWith("/")) {
            name = "/" + name;
        }
        if ((eApp = EnterpriseApplication.getLocal()) != null) {
            return "/" + eApp.getName() + "_" + name.substring(1);
        }
        return name;
    }
}

