/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.ql;

import com.caucho.config.ConfigException;
import com.caucho.ejb.ql.Expr;
import com.caucho.util.CharBuffer;

class BetweenExpr
extends Expr {
    private Expr _value;
    private Expr _min;
    private Expr _max;
    private boolean _isNot;

    BetweenExpr(Expr value, Expr min, Expr max, boolean isNot) throws ConfigException {
        this._value = value;
        this._min = min;
        this._max = max;
        this._isNot = isNot;
        this.evalTypes();
    }

    void evalTypes() throws ConfigException {
        if (this.getJavaType() != null) {
            return;
        }
        this.setJavaType(Boolean.TYPE);
        if (this._value.isDate() && this._min.isDate() && this._max.isDate()) {
            return;
        }
        if (this._value.isDate()) {
            throw this.error(L.l("BETWEEN expects date expression at `{0}'.  All values must either be date values or all must be numeric values.", (Object)this._value));
        }
        if (this._min.isDate()) {
            throw this.error(L.l("BETWEEN expects date expression at `{0}'.  All values must either be date values or all must be numeric values.", (Object)this._min));
        }
        if (this._max.isDate()) {
            throw this.error(L.l("BETWEEN expects date expression at `{0}'.  All values must either be date values or all must be numeric values.", (Object)this._max));
        }
        if (!this._value.isNumeric()) {
            throw this.error(L.l("BETWEEN expects numeric expression at `{0}'", (Object)this._value));
        }
        if (!this._min.isNumeric()) {
            throw this.error(L.l("BETWEEN expects numeric expression at `{0}'", (Object)this._min));
        }
        if (!this._max.isNumeric()) {
            throw this.error(L.l("BETWEEN expects numeric expression at `{0}'", (Object)this._max));
        }
    }

    void generateWhere(CharBuffer cb) {
        this._value.generateWhereSubExpr(cb);
        if (this._isNot) {
            cb.append(" NOT BETWEEN ");
        } else {
            cb.append(" BETWEEN ");
        }
        this._min.generateWhereSubExpr(cb);
        cb.append(" AND ");
        this._max.generateWhereSubExpr(cb);
    }

    void generateWhereSubExpr(CharBuffer cb) {
        cb.append("(");
        this.generateWhere(cb);
        cb.append(")");
    }

    public String toString() {
        if (this._isNot) {
            return "NOT BETWEEN " + this._min + " AND " + this._max;
        }
        return "BETWEEN " + this._min + " AND " + this._max;
    }
}

