/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.ql;

import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg21.CmrRelation;
import com.caucho.ejb.cfg21.EjbEntityBean;
import com.caucho.ejb.ql.CollectionIdExpr;
import com.caucho.ejb.ql.Expr;
import com.caucho.ejb.ql.PathExpr;
import com.caucho.ejb.ql.Query;
import com.caucho.util.CharBuffer;

class CollectionExpr
extends Expr {
    private PathExpr _base;
    private String _fieldName;
    private CmrRelation _relation;
    private CollectionIdExpr _id;
    private boolean _usesField;

    CollectionExpr(Query query, PathExpr base, String field, CmrRelation relation) throws ConfigException {
        this._query = query;
        this._base = base;
        this._fieldName = field;
        this._relation = relation;
        base.setUsesField();
    }

    void setId(CollectionIdExpr id) {
        if (this._id != null) {
            throw new RuntimeException();
        }
        this._id = id;
    }

    CollectionIdExpr getId() {
        return this._id;
    }

    void setUsesField() {
        if (!this._usesField) {
            this._usesField = true;
        }
    }

    PathExpr getBase() {
        return this._base;
    }

    EjbEntityBean getItemBean() {
        return this._relation.getTargetBean();
    }

    int getComponentCount() {
        EjbEntityBean bean = this.getItemBean();
        EntityType type = bean.getEntityType();
        return type.getId().getKeyCount();
    }

    String getReturnEJB() {
        return this.getItemBean().getEJBName();
    }

    CmrRelation getRelation() {
        return this._relation;
    }

    void generateSelect(CharBuffer cb) {
        this._base.generateSelect(cb);
        cb.append('.');
        cb.append(this._fieldName);
    }

    public String toString() {
        return String.valueOf(this._base) + "." + this._fieldName;
    }
}

