/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.ql;

import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg21.EjbEntityBean;
import com.caucho.ejb.ql.CollectionExpr;
import com.caucho.ejb.ql.PathExpr;
import com.caucho.ejb.ql.Query;
import com.caucho.util.CharBuffer;

class CollectionIdExpr
extends PathExpr {
    private String _name;
    private CollectionExpr _path;
    private String _keyTable;
    private String[] _keyColumns;
    private boolean _usesField;

    CollectionIdExpr(Query query, String name, CollectionExpr path) throws ConfigException {
        super(path.getItemBean());
        this._query = query;
        this._name = name;
        this._path = path;
        path.setId(this);
        if (this.getBean() == null) {
            throw new NullPointerException("unknown bean for " + name + " " + query);
        }
    }

    CollectionExpr getPath() {
        return this._path;
    }

    void setUsesField() {
        if (this._usesField) {
            return;
        }
        this._usesField = true;
    }

    String getKeyTable() {
        return this._keyTable;
    }

    String[] getKeyFields() {
        return this._keyColumns;
    }

    int getComponentCount() {
        return this._path.getComponentCount();
    }

    String getTable() {
        return this._name;
    }

    String getName() {
        return this._name;
    }

    EjbEntityBean getBean() {
        return this._bean;
    }

    EjbEntityBean getItemBean() {
        return this._bean;
    }

    String getReturnEJB() {
        return this.getItemBean().getEJBName();
    }

    void printSelect(CharBuffer cb) throws ConfigException {
        String[] names = this.getKeyFields();
        for (int i = 0; i < names.length; ++i) {
            if (i != 0) {
                cb.append(", ");
            }
            cb.append(this.getKeyTable());
            cb.append(".");
            cb.append(names[i]);
        }
    }

    String getSelectTable(CharBuffer cb) throws ConfigException {
        return this.getKeyTable();
    }

    void printWhere(CharBuffer cb) throws ConfigException {
        String[] names = this.getKeyFields();
        if (names.length != 1) {
            throw new RuntimeException();
        }
        cb.append(this.getKeyTable());
        cb.append(".");
        cb.append(names[0]);
    }

    void printComponent(CharBuffer cb, int index) throws ConfigException {
        cb.append(this.getKeyTable());
        cb.append(".");
        cb.append(this.getKeyFields()[index]);
    }

    void generateWhere(CharBuffer cb) {
        if (this._bean == null) {
            throw new IllegalStateException("no bean for " + this.getName());
        }
        cb.append(this.getName());
    }

    void generateComponent(CharBuffer cb, int i) {
        if (this._bean == null) {
            throw new IllegalStateException("no bean for " + this.getName());
        }
        cb.append(this.getName());
        cb.append('.');
        cb.append(this.generateKeyField(this.getItemBean().getEntityType(), i));
    }

    void generateAmber(CharBuffer cb) {
        cb.append("IN(");
        this._path.generateSelect(cb);
        cb.append(") ");
        cb.append(this.getName());
    }

    public boolean equals(Object bObj) {
        if (!(bObj instanceof CollectionIdExpr)) {
            return false;
        }
        CollectionIdExpr b = (CollectionIdExpr)bObj;
        return this._name.equals(b._name);
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public String toString() {
        return this._name;
    }
}

