/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.ql;

import com.caucho.amber.field.IdField;
import com.caucho.amber.field.KeyManyToOneField;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg21.EjbEntityBean;
import com.caucho.ejb.ql.FieldExpr;
import com.caucho.ejb.ql.Query;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Expr {
    static final Logger log = Log.open(Expr.class);
    static final L10N L = new L10N(Expr.class);
    protected Query _query;
    private Class _javaType;

    public Class getJavaType() {
        return this._javaType;
    }

    void setJavaType(Class javaType) {
        this._javaType = javaType;
    }

    String getReturnEJB() {
        return null;
    }

    boolean isKey() {
        return this.getReturnEJB() != null;
    }

    boolean isNumeric() {
        Class type = this.getJavaType();
        if (type == null) {
            return false;
        }
        String typeName = type.getName();
        if ("java.lang.Byte".equals(typeName) || "java.lang.Short".equals(typeName) || "java.lang.Integer".equals(typeName) || "java.lang.Long".equals(typeName) || "java.lang.Float".equals(typeName) || "java.lang.Double".equals(typeName)) {
            return true;
        }
        if (!type.isPrimitive()) {
            return false;
        }
        return !typeName.equals("boolean") && !typeName.equals("char");
    }

    boolean isInteger() {
        Class type = this.getJavaType();
        String typeName = type.getName();
        return "java.lang.Byte".equals(typeName) || "java.lang.Short".equals(typeName) || "java.lang.Integer".equals(typeName) || "java.lang.Long".equals(typeName) || "byte".equals(typeName) || "short".equals(typeName) || "int".equals(typeName) || "long".equals(typeName);
    }

    static boolean isInteger(Class type) {
        String typeName = type.getName();
        return "java.lang.Byte".equals(typeName) || "java.lang.Short".equals(typeName) || "java.lang.Integer".equals(typeName) || "java.lang.Long".equals(typeName) || "byte".equals(typeName) || "short".equals(typeName) || "int".equals(typeName) || "long".equals(typeName);
    }

    int getComponentCount() {
        return 1;
    }

    boolean isString() {
        Class type = this.getJavaType();
        String typeName = type.getName();
        return "java.lang.String".equals(typeName) || "char".equals(typeName) || "java.lang.Character".equals(typeName);
    }

    boolean isBoolean() {
        Class type = this.getJavaType();
        String typeName = type.getName();
        return "boolean".equals(typeName) || "java.lang.Boolean".equals(typeName);
    }

    boolean isDate() {
        Class type = this.getJavaType();
        String typeName = type.getName();
        return "java.util.Date".equals(typeName) || "java.sql.Timestamp".equals(typeName) || "java.sql.Date".equals(typeName) || "java.sql.Time".equals(typeName);
    }

    boolean canCoerce() {
        return false;
    }

    boolean isCollection() {
        Class type = this.getJavaType();
        return Collection.class.isAssignableFrom(type);
    }

    boolean isExternal() {
        return false;
    }

    EjbEntityBean getItemBean() {
        return null;
    }

    Expr newField(String field) throws ConfigException {
        throw this.error(L.l("'{0}' can't have field '{1}'.  Only path expressions referring to a single bean have fields.", (Object)this, (Object)field));
    }

    FieldExpr newReference(String field) throws ConfigException {
        throw this.error(L.l("'{0}' can't have reference '{1}'", (Object)this, (Object)field));
    }

    void evalTypes() throws ConfigException {
        if (this.getJavaType() == null) {
            throw this.error(L.l("'{0}' has no type.", (Object)this) + this.getClass());
        }
    }

    void generateSelect(CharBuffer cb) {
        this.generateWhere(cb);
    }

    String getSelectTable(CharBuffer cb) throws ConfigException {
        throw new IllegalStateException(L.l("'{0}' can't be used in a SELECT expression", (Object)this));
    }

    void generateWhere(CharBuffer cb) {
        throw new IllegalStateException(L.l("{0}: '{1}' can't be used in a WHERE expression", (Object)this.getClass().getName(), (Object)this));
    }

    void generateWhereSubExpr(CharBuffer cb) {
        this.generateWhere(cb);
    }

    void generateComponent(CharBuffer cb, int i) {
        if (i != 0) {
            throw new IllegalStateException(L.l("'{0}' can't be used in a WHERE multi-component", (Object)this));
        }
        this.generateWhereSubExpr(cb);
    }

    protected String keyComponent(EntityType type, int index) {
        ArrayList<String> names = new ArrayList<String>();
        this.addKeys(names, type, "");
        Collections.sort(names);
        return names.get(index);
    }

    protected void addKeys(ArrayList<String> names, EntityType type, String prefix) {
        for (IdField key : type.getId().getKeys()) {
            if (key instanceof KeyManyToOneField) {
                KeyManyToOneField manyToOne = (KeyManyToOneField)key;
                this.addKeys(names, manyToOne.getEntityType(), prefix + key.getName() + ".");
                continue;
            }
            names.add(prefix + key.getName());
        }
    }

    ConfigException error(String msg) {
        if (this._query != null) {
            return this._query.error(msg);
        }
        return new ConfigException(msg);
    }

    ConfigException error(Query query, String msg) {
        return query.error(msg);
    }
}

