/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.ql;

import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg21.EjbEntityBean;
import com.caucho.ejb.ql.CollectionExpr;
import com.caucho.ejb.ql.CollectionIdExpr;
import com.caucho.ejb.ql.Expr;
import com.caucho.ejb.ql.FieldExpr;
import com.caucho.ejb.ql.PathExpr;
import com.caucho.ejb.ql.Query;
import com.caucho.util.CharBuffer;
import java.lang.reflect.Method;

class MemberExpr
extends Expr {
    private PathExpr _item;
    private CollectionExpr _collection;
    private CollectionIdExpr _collectionId;
    private boolean _isNot;
    private Query _parent;

    MemberExpr(boolean isNot, Expr item, Expr collection) throws ConfigException {
        this._isNot = isNot;
        if (collection instanceof CollectionExpr) {
            this._collection = (CollectionExpr)collection;
        } else if (collection instanceof CollectionIdExpr) {
            this._collectionId = (CollectionIdExpr)collection;
        } else {
            throw this.error(L.l("MEMBER OF needs a collection-valued field at `{0}'.", (Object)collection));
        }
        if (!(item instanceof PathExpr)) {
            throw this.error(L.l("MEMBER OF needs a single-valued field at `{0}'.", (Object)item));
        }
        this._item = (PathExpr)item;
        this.setJavaType(Boolean.TYPE);
    }

    public String addRelation(EjbEntityBean bean, FieldExpr id) throws ConfigException {
        return null;
    }

    public Method getMethod() {
        throw new UnsupportedOperationException();
    }

    public EjbEntityBean getPersistentBean() {
        throw new UnsupportedOperationException();
    }

    public void addArg(Expr arg) {
        throw new UnsupportedOperationException();
    }

    void generateWhere(CharBuffer cb) {
        if (this._isNot) {
            cb.append("NOT ");
        }
        this._item.generateWhere(cb);
        cb.append(" MEMBER OF (");
        if (this._collection != null) {
            this._collection.generateSelect(cb);
        } else {
            this._collectionId.generateSelect(cb);
        }
        cb.append(")");
    }

    public String toString() {
        String str = this._item.toString();
        if (this._isNot) {
            return str + " NOT MEMBER OF " + this._collection;
        }
        return str + " MEMBER OF " + this._collection;
    }
}

