/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.ql;

import com.caucho.config.ConfigException;
import com.caucho.ejb.ql.Expr;
import com.caucho.util.CharBuffer;

class UnaryExpr
extends Expr {
    private int _op;
    private Expr _expr;

    UnaryExpr(int op, Expr expr) throws ConfigException {
        this._op = op;
        this._expr = expr;
        this.evalTypes();
    }

    void evalTypes() throws ConfigException {
        if (this.getJavaType() != null) {
            return;
        }
        switch (this._op) {
            case 43: {
                if (!this._expr.isNumeric()) {
                    throw this.error(L.l("'+' expects numeric expression at '{0}'", (Object)this._expr));
                }
                this.setJavaType(this._expr.getJavaType());
                break;
            }
            case 45: {
                if (!this._expr.isNumeric()) {
                    throw this.error(L.l("'-' expects numeric expression at '{0}'", (Object)this._expr));
                }
                this.setJavaType(this._expr.getJavaType());
                break;
            }
            case 163: {
                if (!this._expr.isBoolean()) {
                    throw this.error(L.l("NOT expects boolean expression at '{0}'", (Object)this._expr));
                }
                this.setJavaType(Boolean.TYPE);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    void generateWhere(CharBuffer cb) {
        switch (this._op) {
            case 43: {
                cb.append("+");
                break;
            }
            case 45: {
                cb.append("-");
                break;
            }
            case 163: {
                cb.append("NOT ");
            }
        }
        this._expr.generateWhereSubExpr(cb);
    }
}

