/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.session;

import com.caucho.ejb.AbstractContext;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.manager.EjbContainer;
import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.component.SingletonComponent;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.SessionContext;
import javax.webbeans.Named;

public abstract class SessionServer
extends AbstractServer {
    private static final Logger log = Logger.getLogger(SessionServer.class.getName());
    private HashMap<Class, ComponentImpl> _componentMap = new HashMap();

    public SessionServer(EjbContainer manager) {
        super(manager);
    }

    protected String getType() {
        return "session:";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._loader);
            super.init();
            WebBeansContainer webBeans = WebBeansContainer.create();
            SingletonComponent comp = new SingletonComponent(webBeans, (Object)this.getSessionContext());
            comp.setTargetType((Type)((Object)SessionContext.class));
            comp.init();
            webBeans.addComponent(comp);
            if (this._localHomeClass != null) {
                this._localHome = (EJBLocalHome)this.getLocalObject(this._localHomeClass);
            }
            if (this._remoteHomeClass != null) {
                this._remoteHome = (EJBHome)this.getRemoteObject(this._remoteHomeClass);
            }
            Object var6_5 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
        this.registerWebBeans();
        log.fine(this + " initialized");
    }

    private void registerWebBeans() {
        Class beanClass = this.getBeanSkelClass();
        ArrayList<Class> localApiList = this.getLocalApiList();
        ArrayList<Class> remoteApiList = this.getRemoteApiList();
        if (beanClass != null && (localApiList != null || remoteApiList != null)) {
            ComponentImpl comp;
            WebBeansContainer webBeans = WebBeansContainer.create();
            String beanName = this.getEJBName();
            Named named = beanClass.getAnnotation(Named.class);
            if (named != null) {
                beanName = named.value();
            }
            if (localApiList != null) {
                for (Class api : localApiList) {
                    comp = this.createSessionComponent(api);
                    comp.setTargetType(api);
                    comp.setName(beanName);
                    comp.addNameBinding(beanName);
                    comp.init();
                    webBeans.addComponentByName(beanName, comp);
                    webBeans.addComponentByType(api, comp);
                    this._componentMap.put(api, comp);
                }
            }
            if (remoteApiList != null) {
                for (Class api : remoteApiList) {
                    comp = this.createSessionComponent(api);
                    comp.setTargetType(api);
                    comp.setName(beanName);
                    comp.addNameBinding(beanName);
                    comp.init();
                    webBeans.addComponentByName(beanName, comp);
                    webBeans.addComponentByType(api, comp);
                    this._componentMap.put(api, comp);
                }
            }
        }
    }

    protected void bindInjection() {
        super.bindInjection();
        for (ComponentImpl comp : this._componentMap.values()) {
            comp.bind();
        }
    }

    protected abstract ComponentImpl createSessionComponent(Class var1);

    protected ComponentImpl getComponent(Class api) {
        return this._componentMap.get(api);
    }

    public Class getPrimaryKeyClass() {
        return null;
    }

    public EJBLocalHome getEJBLocalHome() {
        return this._localHome;
    }

    public AbstractContext getContext() {
        return this.getSessionContext();
    }
}

