/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.session;

import com.caucho.config.ConfigContext;
import com.caucho.ejb.AbstractContext;
import com.caucho.ejb.EJBExceptionWrapper;
import com.caucho.ejb.manager.EjbContainer;
import com.caucho.ejb.protocol.AbstractHandle;
import com.caucho.ejb.session.AbstractSessionContext;
import com.caucho.ejb.session.SessionServer;
import com.caucho.ejb.session.StatefulComponent;
import com.caucho.ejb.session.StatefulContext;
import com.caucho.ejb.session.StatefulObject;
import com.caucho.ejb.session.StatefulProvider;
import com.caucho.ejb.session.StatefulProviderProxy;
import com.caucho.util.LruCache;
import com.caucho.webbeans.component.ComponentImpl;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.FinderException;
import javax.ejb.NoSuchEJBException;

public class StatefulServer
extends SessionServer {
    private static final Logger log = Logger.getLogger(StatefulServer.class.getName());
    private StatefulContext _homeContext;
    private LruCache<String, StatefulObject> _remoteSessions;

    public StatefulServer(EjbContainer ejbContainer) {
        super(ejbContainer);
    }

    protected String getType() {
        return "stateful:";
    }

    public AbstractSessionContext getSessionContext() {
        return this.getStatefulContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatefulContext getStatefulContext() {
        StatefulServer statefulServer = this;
        synchronized (statefulServer) {
            if (this._homeContext == null) {
                try {
                    Class[] param = new Class[]{StatefulServer.class};
                    Constructor cons = this._contextImplClass.getConstructor(param);
                    this._homeContext = (StatefulContext)cons.newInstance(this);
                }
                catch (Exception e) {
                    throw new EJBExceptionWrapper(e);
                }
            }
        }
        return this._homeContext;
    }

    public Object getLocalProxy(Class api) {
        StatefulProvider provider = this.getStatefulContext().getProvider(api);
        if (provider != null) {
            return new StatefulProviderProxy(provider);
        }
        return null;
    }

    public Object getLocalObject(Class api) {
        StatefulProvider provider = this.getStatefulContext().getProvider(api);
        if (provider != null) {
            return provider.__caucho_createNew(new ConfigContext());
        }
        return null;
    }

    protected ComponentImpl createSessionComponent(Class api) {
        StatefulProvider provider = this.getStatefulContext().getProvider(api);
        if (provider != null) {
            return new StatefulComponent(provider);
        }
        return null;
    }

    AbstractHandle createHandle(AbstractContext context) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void addSession(StatefulObject remoteObject) {
        this.createSessionKey(remoteObject);
    }

    public AbstractContext getContext(Object key, boolean forceLoad) throws FinderException {
        throw new NoSuchEJBException("no matching object:" + key);
    }

    public Object getRemoteObject(Object key) {
        StatefulObject remote = null;
        if (this._remoteSessions != null) {
            remote = (StatefulObject)this._remoteSessions.get((Object)String.valueOf(key));
        }
        return remote;
    }

    public String createSessionKey(StatefulObject remote) {
        String key = this.getHandleEncoder().createRandomStringKey();
        if (this._remoteSessions == null) {
            this._remoteSessions = new LruCache(8192);
        }
        this._remoteSessions.put((Object)key, (Object)remote);
        return key;
    }

    public Object getRemoteObject(Class api, String protocol) {
        StatefulProvider provider = this.getStatefulContext().getProvider(api);
        if (provider != null) {
            Object value = provider.__caucho_createNew(null);
            return value;
        }
        return null;
    }

    public Object remove(AbstractHandle handle) {
        if (this._remoteSessions != null) {
            return this._remoteSessions.remove((Object)handle.getObjectId());
        }
        return null;
    }

    public void remove(Object key) {
        if (this._remoteSessions != null) {
            this._remoteSessions.remove((Object)String.valueOf(key));
        }
    }

    public void destroy() {
        super.destroy();
        ArrayList values = new ArrayList();
        if (this._remoteSessions != null) {
            Iterator iter = this._remoteSessions.values();
            while (iter.hasNext()) {
                values.add(iter.next());
            }
        }
        this._remoteSessions = null;
        for (StatefulObject obj : values) {
            try {
                obj.remove();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        log.fine(this + " closed");
    }
}

