/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.session;

import com.caucho.config.j2ee.PreDestroyInject;
import com.caucho.config.program.ConfigProgram;
import com.caucho.ejb.AbstractContext;
import com.caucho.ejb.EJBExceptionWrapper;
import com.caucho.ejb.manager.EjbContainer;
import com.caucho.ejb.protocol.AbstractHandle;
import com.caucho.ejb.protocol.ObjectSkeletonWrapper;
import com.caucho.ejb.session.AbstractSessionContext;
import com.caucho.ejb.session.SessionServer;
import com.caucho.ejb.session.StatelessComponent;
import com.caucho.ejb.session.StatelessContext;
import com.caucho.ejb.session.StatelessObject;
import com.caucho.ejb.session.StatelessProvider;
import com.caucho.ejb.session.StatelessProviderProxy;
import com.caucho.webbeans.component.ComponentImpl;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBObject;
import javax.ejb.FinderException;
import javax.ejb.Remove;
import javax.ejb.SessionBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatelessServer
extends SessionServer {
    protected static Logger log = Logger.getLogger(StatelessServer.class.getName());
    private StatelessContext _homeContext;
    private StatelessProvider _remoteProvider;

    public StatelessServer(EjbContainer ejbContainer) {
        super(ejbContainer);
    }

    @Override
    protected String getType() {
        return "stateless:";
    }

    @Override
    public Object getLocalProxy(Class api) {
        StatelessProvider provider = this.getStatelessContext().getProvider(api);
        return new StatelessProviderProxy(provider);
    }

    @Override
    public Object getLocalObject(Class api) {
        return this.getStatelessContext().getProvider(api);
    }

    @Override
    protected ComponentImpl createSessionComponent(Class api) {
        StatelessProvider provider = this.getStatelessContext().getProvider(api);
        return new StatelessComponent(provider, api);
    }

    public Object getRemoteObject() {
        if (this._remoteProvider != null) {
            return this._remoteProvider.__caucho_get();
        }
        return null;
    }

    @Override
    public Object getRemoteObject(Class api, String protocol) {
        if (api == null) {
            return null;
        }
        StatelessProvider provider = this.getStatelessContext().getProvider(api);
        if (provider != null) {
            Object result = provider.__caucho_get();
            return result;
        }
        log.fine(this + " unknown api " + api.getName());
        return null;
    }

    @Override
    public Object getRemoteObject(Object key) {
        if (this._remoteProvider != null) {
            return this._remoteProvider.__caucho_get();
        }
        return null;
    }

    @Override
    public void init() throws Exception {
        super.init();
        ArrayList<Class> remoteApiList = this.getRemoteApiList();
        if (remoteApiList != null && remoteApiList.size() > 0) {
            Class api = remoteApiList.get(0);
            this._remoteProvider = this.getStatelessContext().getProvider(api);
        }
    }

    @Override
    protected void introspectDestroy(ArrayList<ConfigProgram> injectList, Class ejbClass) {
        super.introspectDestroy(injectList, ejbClass);
        for (Method method : ejbClass.getDeclaredMethods()) {
            if (method.isAnnotationPresent(Remove.class) && method.getParameterTypes().length == 0) {
                injectList.add(new PreDestroyInject(method));
                continue;
            }
            if (!"ejbRemove".equals(method.getName()) || !SessionBean.class.isAssignableFrom(ejbClass)) continue;
            injectList.add(new PreDestroyInject(method));
        }
    }

    @Override
    public EJBObject getEJBObject(Object key) throws FinderException {
        return this.getStatelessContext().getEJBObject();
    }

    @Override
    public AbstractContext getContext() {
        return this.getStatelessContext();
    }

    @Override
    public AbstractContext getContext(Object key, boolean forceLoad) {
        return this.getStatelessContext();
    }

    @Override
    public AbstractSessionContext getSessionContext() {
        return this.getStatelessContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatelessContext getStatelessContext() {
        StatelessServer statelessServer = this;
        synchronized (statelessServer) {
            if (this._homeContext == null) {
                try {
                    Class[] param = new Class[]{StatelessServer.class};
                    Constructor cons = this._contextImplClass.getConstructor(param);
                    this._homeContext = (StatelessContext)cons.newInstance(this);
                }
                catch (Exception e) {
                    throw new EJBExceptionWrapper(e);
                }
            }
        }
        return this._homeContext;
    }

    Object getObjectHandle(StatelessObject obj, Class api) {
        ComponentImpl comp = this.getComponent(api);
        if (comp != null) {
            return comp.getHandle();
        }
        return new ObjectSkeletonWrapper(obj.getHandle());
    }

    AbstractHandle createHandle(AbstractContext context) {
        String key = this.createSessionKey(context);
        return this.getHandleEncoder().createHandle(key);
    }

    String createSessionKey(AbstractContext context) {
        return "::ejb:stateless";
    }

    @Override
    public void destroy() {
        if (this._homeContext != null) {
            try {
                this._homeContext.destroy();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        super.destroy();
    }
}

