/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.timer;

import com.caucho.ejb.AbstractContext;
import com.caucho.ejb.timer.EjbTimerHandle;
import com.caucho.server.util.ScheduledThreadPool;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;

public class EjbTimer
implements Timer,
Runnable {
    private static final L10N L = new L10N(EjbTimer.class);
    protected static final Logger log = Logger.getLogger(EjbTimer.class.getName());
    private ScheduledThreadPool _threadPool;
    private Future _future;
    private Date _expiration;
    private long _interval;
    private Serializable _info;
    private AbstractContext _context;
    private long _timerId;
    private static long _currentTimerId;

    EjbTimer(Date expiration, Serializable info, AbstractContext context) {
        this(expiration, -1L, info, context);
    }

    EjbTimer(Date expiration, long interval, Serializable info, AbstractContext context) {
        this._expiration = expiration;
        this._interval = interval;
        this._info = info;
        if (context == null) {
            throw new NullPointerException();
        }
        this._context = context;
        this._timerId = _currentTimerId++;
        long initialDelay = this.getTimeRemaining();
        this._threadPool = ScheduledThreadPool.getLocal();
        this._future = interval <= 0L ? this._threadPool.schedule(this, initialDelay, TimeUnit.MILLISECONDS) : this._threadPool.scheduleWithFixedDelay(this, initialDelay, interval, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws NoSuchObjectLocalException, EJBException {
        try {
            this._future.cancel(true);
            Object var2_1 = null;
            this._expiration = new Date(Alarm.getCurrentTime());
            this._interval = -1L;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this._expiration = new Date(Alarm.getCurrentTime());
            this._interval = -1L;
            throw throwable;
        }
    }

    public TimerHandle getHandle() throws NoSuchObjectLocalException, EJBException {
        return new EjbTimerHandle(this._expiration, this._interval, this._info, this._context.getServer().getEJBName(), this._timerId);
    }

    public Serializable getInfo() throws NoSuchObjectLocalException, EJBException {
        return this._info;
    }

    public Date getNextTimeout() throws NoSuchObjectLocalException, EJBException {
        this.checkExpiration();
        return this._expiration;
    }

    public long getTimeRemaining() throws NoSuchObjectLocalException, EJBException {
        return this.checkExpiration();
    }

    public void run() {
        this._context.__caucho_timeout_callback(this);
    }

    long __caucho_getId() {
        return this._timerId;
    }

    private long checkExpiration() {
        long delay = this._expiration.getTime() - Alarm.getCurrentTime();
        if (delay < 0L && this._interval < 0L) {
            throw new NoSuchObjectLocalException(this + " is expired");
        }
        return delay;
    }

    public String toString() {
        return "EjbTimer[" + this._timerId + ", " + this._expiration + ", " + this._interval + ", " + this._info + "]";
    }
}

