/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.timer;

import com.caucho.ejb.AbstractContext;
import com.caucho.ejb.timer.EjbTimer;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.Timer;
import javax.ejb.TimerService;

public class EjbTimerService
implements TimerService {
    private static final L10N L = new L10N(EjbTimerService.class);
    protected static final Logger log = Logger.getLogger(EjbTimerService.class.getName());
    private static final EnvironmentLocal<EjbTimerService> _localTimer = new EnvironmentLocal();
    private AbstractContext _context;
    private ArrayList<EjbTimer> _timers = new ArrayList();

    EjbTimerService(AbstractContext context) {
        this._context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EjbTimerService getLocal(ClassLoader loader, AbstractContext context) {
        EnvironmentLocal<EjbTimerService> environmentLocal = _localTimer;
        synchronized (environmentLocal) {
            EjbTimerService timer = _localTimer.get(loader);
            if (timer == null) {
                timer = new EjbTimerService(context);
                _localTimer.set(timer, loader);
            }
            return timer;
        }
    }

    public static EjbTimerService getCurrent() {
        return EjbTimerService.getCurrent(Thread.currentThread().getContextClassLoader());
    }

    public static EjbTimerService getCurrent(ClassLoader loader) {
        return _localTimer.get(loader);
    }

    public Timer createTimer(long duration, Serializable info) throws EJBException {
        if (duration < 0L) {
            throw new IllegalArgumentException("Timer duration must not be negative");
        }
        Date expiration = new Date(Alarm.getCurrentTime() + duration);
        return this.createTimer(expiration, info);
    }

    public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws EJBException {
        if (initialDuration < 0L) {
            throw new IllegalArgumentException("Timer initial duration must not be negative");
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("Timer interval duration must not be negative");
        }
        Date initialExpiration = new Date(Alarm.getCurrentTime() + initialDuration);
        return this.createTimer(initialExpiration, intervalDuration, info);
    }

    public Timer createTimer(Date expiration, Serializable info) throws EJBException {
        EjbTimer timer = new EjbTimer(expiration, info, this._context);
        this._timers.add(timer);
        return timer;
    }

    public Timer createTimer(Date expiration, long interval, Serializable info) throws EJBException {
        if (interval < 0L) {
            throw new IllegalArgumentException("Timer interval must not be negative");
        }
        EjbTimer timer = new EjbTimer(expiration, interval, info, this._context);
        this._timers.add(timer);
        return timer;
    }

    public Collection getTimers() throws EJBException {
        return this._timers;
    }

    EjbTimer __caucho_find(long timerId) {
        for (EjbTimer timer : this._timers) {
            if (timer.__caucho_getId() != timerId) continue;
            return timer;
        }
        return null;
    }

    public String toString() {
        return "EjbTimerService[]";
    }
}

