/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.xa;

import com.caucho.amber.manager.AmberConnection;
import com.caucho.config.ConfigException;
import com.caucho.ejb.EJBExceptionWrapper;
import com.caucho.ejb.manager.EjbContainer;
import com.caucho.ejb.xa.TransactionContext;
import com.caucho.log.Log;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.EJBTransactionRequiredException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public class EjbTransactionManager
implements Serializable {
    private static final L10N L = new L10N(EjbTransactionManager.class);
    private static final Logger log = Log.open(EjbTransactionManager.class);
    public static final int RESIN_DATABASE = 0;
    public static final int RESIN_READ_ONLY = 1;
    public static final int RESIN_ROW_LOCKING = 2;
    protected static final ThreadLocal<TransactionContext> _threadTransaction = new ThreadLocal();
    private FreeList<TransactionContext> _freeTransactions = new FreeList(64);
    private Hashtable<Transaction, TransactionContext> _transactionMap = new Hashtable();
    private Hashtable<String, TransactionContext> _foreignTransactionMap = new Hashtable();
    private final EjbContainer _ejbContainer;
    protected final TransactionManager _transactionManager;
    protected UserTransaction _userTransaction;
    private int _resinIsolation = -1;
    private int _jdbcIsolation = -1;
    private long _transactionTimeout = 0L;
    private boolean _isClosed;
    private boolean _isEJB3;

    public EjbTransactionManager(EjbContainer ejbContainer) throws ConfigException {
        this._ejbContainer = ejbContainer;
        UserTransaction ut = null;
        TransactionManager tm = null;
        try {
            InitialContext ic = new InitialContext();
            ut = (UserTransaction)ic.lookup("java:comp/UserTransaction");
            tm = (TransactionManager)ic.lookup("java:comp/TransactionManager");
        }
        catch (NamingException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        this._userTransaction = ut;
        this._transactionManager = tm;
        if (this._transactionManager == null) {
            throw new ConfigException(L.l("Can't load TransactionManager."));
        }
    }

    public EjbContainer getEjbContainer() {
        return this._ejbContainer;
    }

    public void setEJB3(boolean isEJB3) {
        this._isEJB3 = isEJB3;
    }

    public boolean isEJB3() {
        return this._isEJB3;
    }

    public void setResinIsolation(int resinIsolation) {
        this._resinIsolation = resinIsolation;
    }

    public int getResinIsolation() {
        return this._resinIsolation;
    }

    public void setJDBCIsolation(int jdbcIsolation) {
        this._jdbcIsolation = jdbcIsolation;
    }

    public int getJDBCIsolation() {
        return this._jdbcIsolation;
    }

    public long getTransactionTimeout() {
        return this._transactionTimeout;
    }

    public void setTransactionTimeout(long transactionTimeout) {
        this._transactionTimeout = transactionTimeout;
    }

    void setUserTransaction(UserTransaction userTransaction) {
        this._userTransaction = userTransaction;
    }

    public UserTransaction getUserTransaction() {
        return this._userTransaction;
    }

    public AmberConnection getAmberConnection() {
        TransactionContext xaContext = _threadTransaction.get();
        if (xaContext != null) {
            return xaContext.getAmberConnection();
        }
        throw new IllegalStateException("can't get transaction outside of context");
    }

    public void commitTransaction() throws EJBException {
        try {
            if (this._transactionManager.getTransaction() != null) {
                this._userTransaction.commit();
            }
        }
        catch (Exception e) {
            throw EJBExceptionWrapper.create(e);
        }
    }

    public void rollbackTransaction() throws EJBException {
        try {
            this._userTransaction.rollback();
        }
        catch (Exception e) {
            throw EJBExceptionWrapper.create(e);
        }
    }

    TransactionManager getTransactionManager() throws EJBException {
        return this._transactionManager;
    }

    public Transaction getTransaction() throws EJBException {
        try {
            return this._transactionManager.getTransaction();
        }
        catch (Exception e) {
            throw EJBExceptionWrapper.create(e);
        }
    }

    public TransactionContext getTransactionContext() {
        return _threadTransaction.get();
    }

    public TransactionContext beginRequired() throws EJBException {
        try {
            TransactionContext cxt;
            Transaction oldTrans = this._transactionManager.getTransaction();
            TransactionContext oldCxt = _threadTransaction.get();
            if (oldCxt != null && oldTrans != null && oldCxt.getTransaction() == oldTrans) {
                oldCxt.pushDepth();
                return oldCxt;
            }
            if (oldTrans != null && (cxt = this._transactionMap.get(oldTrans)) != null) {
                this._transactionMap.remove(oldTrans);
                _threadTransaction.set(cxt);
                cxt.pushDepth();
                return cxt;
            }
            cxt = this.createTransaction();
            cxt.setOld(oldCxt);
            _threadTransaction.set(cxt);
            if (oldTrans != null) {
                this.setTransaction(cxt, oldTrans);
                cxt.setUserTransaction(true);
                cxt.pushDepth();
            } else {
                this._userTransaction.setTransactionTimeout((int)(this._transactionTimeout / 1000L));
                this._userTransaction.begin();
                Transaction trans = this._transactionManager.getTransaction();
                this.setTransaction(cxt, trans);
            }
            if (this._resinIsolation == 2) {
                cxt.setRowLocking(true);
            }
            return cxt;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            throw EJBExceptionWrapper.create(e);
        }
    }

    public TransactionContext beginSingleRead() throws EJBException {
        try {
            TransactionContext cxt = _threadTransaction.get();
            Transaction trans = this._transactionManager.getTransaction();
            if (trans == null) {
                return null;
            }
            if (cxt != null && cxt.getTransaction() == trans) {
                cxt.pushDepth();
                return cxt;
            }
            TransactionContext newCxt = this._transactionMap.get(trans);
            if (newCxt != null) {
                newCxt.pushDepth();
                return newCxt;
            }
            newCxt = this.createTransaction();
            newCxt.pushDepth();
            _threadTransaction.set(newCxt);
            this.setTransaction(newCxt, trans);
            newCxt.setUserTransaction(true);
            return newCxt;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            throw EJBExceptionWrapper.create(e);
        }
    }

    public TransactionContext beginRequiresNew() throws EJBException {
        try {
            TransactionContext oldCxt = _threadTransaction.get();
            Transaction oldTrans = this._transactionManager.suspend();
            TransactionContext newCxt = this.createTransaction();
            newCxt.setOld(oldCxt);
            newCxt.setOldTrans(oldTrans);
            _threadTransaction.set(newCxt);
            if (this._resinIsolation == 2) {
                newCxt.setRowLocking(true);
            }
            this._userTransaction.setTransactionTimeout((int)(this._transactionTimeout / 1000L));
            this._userTransaction.begin();
            Transaction trans = this._transactionManager.getTransaction();
            this.setTransaction(newCxt, trans);
            return newCxt;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            throw EJBExceptionWrapper.create(e);
        }
    }

    public TransactionContext beginSupports() throws EJBException {
        try {
            Transaction trans = this._transactionManager.getTransaction();
            TransactionContext cxt = _threadTransaction.get();
            if (cxt == null || cxt.getTransaction() != trans) {
                cxt = trans != null ? this._transactionMap.get(trans) : null;
                if (cxt == null) {
                    cxt = this.createTransactionNoDepth();
                    this.setTransaction(cxt, trans);
                }
                _threadTransaction.set(cxt);
                if (trans != null) {
                    cxt.setUserTransaction(true);
                    cxt.pushDepth();
                }
            }
            cxt.pushDepth();
            if (this._resinIsolation == 2) {
                cxt.setRowLocking(true);
            }
            return cxt;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            throw EJBExceptionWrapper.create(e);
        }
    }

    public TransactionContext suspend() throws EJBException {
        try {
            TransactionContext oldCxt = _threadTransaction.get();
            Transaction oldTrans = this._transactionManager.suspend();
            if (oldTrans == null && oldCxt != null) {
                oldCxt.pushDepth();
                return oldCxt;
            }
            TransactionContext cxt = this.createTransaction();
            _threadTransaction.set(cxt);
            cxt.setOld(oldCxt);
            cxt.setOldTrans(oldTrans);
            return cxt;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            throw EJBExceptionWrapper.create(e);
        }
    }

    public TransactionContext beginNever() throws EJBException {
        try {
            Transaction oldTrans = this._transactionManager.getTransaction();
            if (oldTrans != null) {
                throw new EJBException("Transaction forbidden in 'Never' method");
            }
            TransactionContext cxt = _threadTransaction.get();
            if (cxt == null) {
                cxt = this.createTransaction();
                _threadTransaction.set(cxt);
            } else {
                cxt.pushDepth();
            }
            return cxt;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            throw EJBExceptionWrapper.create(e);
        }
    }

    public TransactionContext beginMandatory() throws EJBException {
        try {
            Transaction trans = this._transactionManager.getTransaction();
            if (trans == null) {
                if (this.isEJB3()) {
                    throw new EJBTransactionRequiredException("Transaction required in 'Mandatory' method");
                }
                throw new EJBException("Transaction required in 'Mandatory' method");
            }
            return this.beginRequired();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            throw EJBExceptionWrapper.create(e);
        }
    }

    public void resume(TransactionContext oldCxt, Transaction oldTrans, Transaction completedTransaction) throws EJBException {
        try {
            if (completedTransaction != null) {
                this._transactionMap.remove(completedTransaction);
            }
            _threadTransaction.set(oldCxt);
            if (oldTrans != null) {
                this._transactionManager.resume(oldTrans);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            throw EJBExceptionWrapper.create(e);
        }
    }

    private void setTransaction(TransactionContext cxt, Transaction trans) {
        if (cxt != null) {
            Transaction old = cxt.getTransaction();
            if (old != null) {
                this._transactionMap.remove(old);
            }
        } else if (trans != null) {
            this._transactionMap.remove(trans);
        }
        cxt.setTransaction(trans);
        if (trans != null) {
            this._transactionMap.put(trans, cxt);
        }
    }

    TransactionContext createTransaction() {
        TransactionContext trans = (TransactionContext)this._freeTransactions.allocate();
        if (trans == null) {
            trans = new TransactionContext(this);
        }
        trans.init(true);
        return trans;
    }

    TransactionContext createTransactionNoDepth() {
        TransactionContext trans = (TransactionContext)this._freeTransactions.allocate();
        if (trans == null) {
            trans = new TransactionContext(this);
        }
        trans.init(false);
        return trans;
    }

    public TransactionContext startTransaction(String xid) {
        try {
            TransactionContext xa = this._foreignTransactionMap.get(xid);
            if (xa != null) {
                this.resume(xa, xa.getTransaction(), null);
                return xa;
            }
            xa = this.beginRequiresNew();
            this._foreignTransactionMap.put(xid, xa);
            return xa;
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
            this._foreignTransactionMap.remove(xid);
            return null;
        }
    }

    public void finishTransaction(String xid) {
        try {
            TransactionContext xa = this._foreignTransactionMap.get(xid);
            if (xa != null) {
                if (xa.isEmpty()) {
                    this._foreignTransactionMap.remove(xid);
                    xa.commit();
                } else {
                    this.suspend();
                }
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void commitTransaction(String xid) {
        try {
            TransactionContext xa = this._foreignTransactionMap.remove(xid);
            if (xa != null) {
                this.resume(xa, xa.getTransaction(), null);
                xa.commit();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void rollbackTransaction(String xid) {
        try {
            TransactionContext xa = this._foreignTransactionMap.remove(xid);
            if (xa != null) {
                this.resume(xa, xa.getTransaction(), null);
                xa.rollback();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    void freeTransaction(TransactionContext trans) {
        this._freeTransactions.free((Object)trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        EjbTransactionManager ejbTransactionManager = this;
        synchronized (ejbTransactionManager) {
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
        }
        this._transactionMap = null;
    }
}

