/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb3.gen;

import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.ApiClass;
import com.caucho.ejb.cfg.ApiMethod;
import com.caucho.ejb.gen.BeanGenerator;
import com.caucho.ejb.gen.BusinessMethodGenerator;
import com.caucho.ejb.gen.PojoView;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import javax.webbeans.BindingType;
import javax.webbeans.In;

public class PojoBean
extends BeanGenerator {
    private static final L10N L = new L10N(PojoBean.class);
    private ApiClass _beanClass;
    private PojoView _view;
    private ArrayList<BusinessMethodGenerator> _businessMethods = new ArrayList();
    private boolean _isEnhanced;
    private boolean _hasXA;
    private boolean _hasReadResolve;
    private boolean _isReadResolveEnhanced;
    private boolean _isSingleton;

    public PojoBean(Class beanClass) {
        super(beanClass.getName() + "$ResinWebBean", new ApiClass(beanClass));
        this.setSuperClassName(beanClass.getName());
        this.addInterfaceName("java.io.Serializable");
        this.addImport("javax.transaction.*");
        this._view = new PojoView(this, this.getEjbClass());
        this._beanClass = new ApiClass(beanClass);
    }

    public void setSingleton(boolean isSingleton) {
        this._isSingleton = isSingleton;
    }

    public void introspect() {
        for (ApiMethod method : this._beanClass.getMethods()) {
            if (Object.class.equals((Object)method.getDeclaringClass())) continue;
            if (method.getName().equals("readResolve") && method.getParameterTypes().length == 0) {
                this._hasReadResolve = true;
            }
            int index = this._businessMethods.size();
            BusinessMethodGenerator bizMethod = new BusinessMethodGenerator(this._view, method, method.getMethod(), index);
            bizMethod.introspect(method.getMethod(), method.getMethod());
            if (!bizMethod.isEnhanced()) continue;
            if (!method.isPublic() && !method.isProtected()) {
                throw new ConfigException(L.l("{0}: Resin-IoC/WebBeans annotations are not allowed on private methods.", (Object)bizMethod));
            }
            if (method.isStatic()) {
                throw new ConfigException(L.l("{0}: Resin-Ioc/WebBeans annotations are not allowed on static methods.", (Object)bizMethod));
            }
            if (method.isFinal()) {
                throw new ConfigException(L.l("{0}: Resin-Ioc/WebBeans annotations are not allowed on final methods.", (Object)bizMethod));
            }
            if (!bizMethod.isEnhanced()) continue;
            this._isEnhanced = true;
            this._businessMethods.add(bizMethod);
        }
        if (Serializable.class.isAssignableFrom(this._beanClass.getJavaClass()) && !this._hasReadResolve && this.hasTransientInject(this._beanClass.getJavaClass())) {
            this._isReadResolveEnhanced = true;
            this._isEnhanced = true;
        }
    }

    private boolean hasTransientInject(Class cl) {
        if (cl == null || Object.class.equals((Object)cl)) {
            return false;
        }
        for (Field field : cl.getDeclaredFields()) {
            Annotation[] annList;
            if (!Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || (annList = field.getDeclaredAnnotations()) == null) continue;
            for (Annotation ann : annList) {
                if (ann.annotationType().isAnnotationPresent(BindingType.class)) {
                    return true;
                }
                if (!In.class.equals(ann.annotationType())) continue;
                return true;
            }
        }
        return this.hasTransientInject(cl.getSuperclass());
    }

    public Class generateClass() {
        if (!this.isEnhanced()) {
            return this._beanClass.getJavaClass();
        }
        try {
            JavaClassGenerator gen = new JavaClassGenerator();
            Class cl = gen.preload(this.getFullClassName());
            if (cl != null) {
                return cl;
            }
            gen.generate(this);
            gen.compilePendingJava();
            return gen.loadClass(this.getFullClassName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isEnhanced() {
        return this._isEnhanced;
    }

    protected void generateClassContent(JavaWriter out) throws IOException {
        this.generateHeader(out);
        HashMap map = new HashMap();
        for (BusinessMethodGenerator method : this._businessMethods) {
            method.generatePrologueTop(out, map);
        }
        for (Constructor<?> ctor : this._beanClass.getJavaClass().getDeclaredConstructors()) {
            if (!Modifier.isPublic(ctor.getModifiers())) continue;
            this.generateConstructor(out, ctor);
        }
        map = new HashMap();
        for (BusinessMethodGenerator method : this._businessMethods) {
            method.generate(out, map);
        }
        this.generateWriteReplace(out);
    }

    protected void generateHeader(JavaWriter out) throws IOException {
        out.println("private static final java.util.logging.Logger __log");
        out.println("  = java.util.logging.Logger.getLogger(\"" + this.getFullClassName() + "\");");
        out.println("private static final boolean __isFiner");
        out.println("  = __log.isLoggable(java.util.logging.Level.FINER);");
        if (this._hasXA) {
            out.println();
            out.println("private static final com.caucho.ejb3.xa.XAManager _xa");
            out.println("  = new com.caucho.ejb3.xa.XAManager();");
        }
    }

    protected void generateReadResolve(JavaWriter out) throws IOException {
        out.println();
        out.println("private Object readResolve()");
        out.println("{");
        out.println("  System.out.println(\"resolve-me\");");
        out.println("  return this;");
        out.println("}");
    }

    protected void generateWriteReplace(JavaWriter out) throws IOException {
        if (this._isSingleton) {
            out.println("private transient Object __caucho_handle;");
            out.println();
            out.println("private Object writeReplace()");
            out.println("{");
            out.println("  return __caucho_handle;");
            out.println("}");
        }
    }

    protected void generateConstructor(JavaWriter out, Constructor ctor) throws IOException {
        int i;
        Class<?>[] paramTypes = ctor.getParameterTypes();
        out.print("public " + this.getClassName() + "(");
        for (i = 0; i < paramTypes.length; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.printClass(paramTypes[i]);
            out.print(" a" + i);
        }
        out.println(")");
        this.generateThrows(out, ctor.getExceptionTypes());
        out.println("{");
        out.pushDepth();
        out.print("super(");
        for (i = 0; i < paramTypes.length; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.print("a" + i);
        }
        out.println(");");
        HashMap map = new HashMap();
        for (BusinessMethodGenerator method : this._businessMethods) {
            method.generateConstructorTop(out, map);
        }
        out.popDepth();
        out.println("}");
    }

    protected void generateThrows(JavaWriter out, Class[] exnCls) throws IOException {
        if (exnCls.length == 0) {
            return;
        }
        out.print(" throws ");
        for (int i = 0; i < exnCls.length; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.printClass(exnCls[i]);
        }
    }
}

