/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb3.xa;

import com.caucho.jca.UserTransactionProxy;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.EJBTransactionRequiredException;
import javax.ejb.SessionSynchronization;
import javax.ejb.TransactionRolledbackLocalException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

public class XAManager {
    private static L10N L = new L10N(XAManager.class);
    private static Logger log = Logger.getLogger(XAManager.class.getName());
    private UserTransactionProxy _ut = UserTransactionProxy.getInstance();

    public void enlist(XAResource xaResource) {
        try {
            TransactionManagerImpl tm = TransactionManagerImpl.getLocal();
            Transaction xa = tm.getTransaction();
            if (xa != null && xaResource != null) {
                xa.enlistResource(xaResource);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public void registerSynchronization(SessionSynchronization sync) {
        try {
            TransactionManagerImpl tm = TransactionManagerImpl.getLocal();
            Transaction xa = tm.getTransaction();
            if (xa != null && sync != null) {
                sync.afterBegin();
                xa.registerSynchronization((Synchronization)new SynchronizationAdapter(sync));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public void beginMandatory() {
        try {
            TransactionManagerImpl tm = TransactionManagerImpl.getLocal();
            Transaction xa = tm.getTransaction();
            if (xa == null) {
                throw new EJBTransactionRequiredException(L.l("Transaction required for for 'Mandatory' TransactionAttribute"));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public void beginNever() {
        try {
            TransactionManagerImpl tm = TransactionManagerImpl.getLocal();
            Transaction xa = tm.getTransaction();
            if (xa != null) {
                throw new EJBException(L.l("Transaction forbidden for 'Never' TransactionAttribute"));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public Transaction beginRequired() {
        try {
            TransactionManagerImpl tm = TransactionManagerImpl.getLocal();
            Transaction xa = tm.getTransaction();
            if (xa != null) {
                return xa;
            }
            this._ut.begin();
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public Transaction beginRequiresNew() {
        try {
            TransactionManagerImpl tm = TransactionManagerImpl.getLocal();
            Transaction xa = tm.suspend();
            this._ut.begin();
            return xa;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endRequiresNew(Transaction xa) {
        this._ut.commit();
        Object var4_2 = null;
        try {
            if (xa == null) return;
            TransactionManagerImpl tm = TransactionManagerImpl.getLocal();
            tm.resume(xa);
            return;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        {
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EJBException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            try {
                if (xa == null) throw throwable;
                TransactionManagerImpl tm = TransactionManagerImpl.getLocal();
                tm.resume(xa);
                throw throwable;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EJBException(e);
            }
        }
    }

    public Transaction beginNotSupported() {
        try {
            TransactionManagerImpl tm = TransactionManagerImpl.getLocal();
            return tm.suspend();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public void markRollback(Exception e) {
        this._ut.setRollbackOnly(e);
    }

    public void commit() {
        try {
            this._ut.commit();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (RollbackException e) {
            throw new TransactionRolledbackLocalException(e.getMessage(), (Exception)((Object)e));
        }
        catch (HeuristicMixedException e) {
            throw new TransactionRolledbackLocalException(e.getMessage(), (Exception)((Object)e));
        }
        catch (HeuristicRollbackException e) {
            throw new TransactionRolledbackLocalException(e.getMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public void resume(Transaction xa) {
        try {
            TransactionManagerImpl tm = TransactionManagerImpl.getLocal();
            tm.resume(xa);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public String toString() {
        return "XAManager[]";
    }

    public static class SynchronizationAdapter
    implements Synchronization {
        private final SessionSynchronization _sync;

        SynchronizationAdapter(SessionSynchronization sync) {
            this._sync = sync;
        }

        public void beforeCompletion() {
            try {
                this._sync.beforeCompletion();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EJBException(e);
            }
        }

        public void afterCompletion(int status) {
            try {
                this._sync.afterCompletion(status == 3);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EJBException(e);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._sync + "]";
        }
    }
}

