/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.Expr;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.el.ELContext;
import javax.el.ELException;

public class DivExpr
extends Expr {
    private final Expr _left;
    private final Expr _right;

    public DivExpr(Expr left, Expr right) {
        this._left = left;
        this._right = right;
    }

    public boolean isConstant() {
        return this._left.isConstant() && this._right.isConstant();
    }

    public Object getValue(ELContext env) throws ELException {
        Object aObj = this._left.getValue(env);
        Object bObj = this._right.getValue(env);
        if (aObj instanceof BigDecimal || bObj instanceof BigDecimal || aObj instanceof BigInteger || bObj instanceof BigInteger) {
            BigDecimal a = DivExpr.toBigDecimal(aObj, env);
            BigDecimal b = DivExpr.toBigDecimal(bObj, env);
            return a.divide(b, 4);
        }
        if (aObj == null && bObj == null) {
            return new Long(0L);
        }
        double a = DivExpr.toDouble(aObj, env);
        double b = DivExpr.toDouble(bObj, env);
        double dValue = a / b;
        return new Double(dValue);
    }

    public long evalLong(ELContext env) throws ELException {
        double a = this._left.evalDouble(env);
        double b = this._right.evalDouble(env);
        return (long)(a / b + 0.5);
    }

    public double evalDouble(ELContext env) throws ELException {
        double a = this._left.evalDouble(env);
        double b = this._right.evalDouble(env);
        return a / b;
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.DivExpr(");
        this._left.printCreate(os);
        os.print(", ");
        this._right.printCreate(os);
        os.print(")");
    }

    public boolean equals(Object o) {
        if (!(o instanceof DivExpr)) {
            return false;
        }
        DivExpr expr = (DivExpr)((Object)o);
        return this._left.equals((Object)expr._left) && this._right.equals((Object)expr._right);
    }

    public String toString() {
        return "(" + (Object)((Object)this._left) + " + " + (Object)((Object)this._right) + ")";
    }
}

