/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.AbstractBooleanExpr;
import com.caucho.el.Expr;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.el.ELContext;
import javax.el.ELException;

public class GeExpr
extends AbstractBooleanExpr {
    private final Expr _left;
    private final Expr _right;

    public GeExpr(Expr left, Expr right) {
        this._left = left;
        this._right = right;
    }

    public boolean isConstant() {
        return this._left.isConstant() && this._right.isConstant();
    }

    public boolean evalBoolean(ELContext env) throws ELException {
        Object bObj;
        Object aObj = this._left.getValue(env);
        if (aObj == (bObj = this._right.getValue(env))) {
            return true;
        }
        if (aObj == null || bObj == null) {
            return false;
        }
        Class<?> aType = aObj.getClass();
        Class<?> bType = bObj.getClass();
        if (aObj instanceof BigDecimal || bObj instanceof BigDecimal) {
            BigDecimal b;
            BigDecimal a = GeExpr.toBigDecimal(aObj, env);
            return a.compareTo(b = GeExpr.toBigDecimal(bObj, env)) >= 0;
        }
        if (aType == Double.class || aType == Float.class || bType == Double.class || bType == Float.class) {
            double b;
            double a = GeExpr.toDouble(aObj, env);
            return a >= (b = GeExpr.toDouble(bObj, env));
        }
        if (aType == BigInteger.class || bType == BigInteger.class) {
            BigInteger b;
            BigInteger a = GeExpr.toBigInteger(aObj, env);
            return a.compareTo(b = GeExpr.toBigInteger(bObj, env)) >= 0;
        }
        if (aObj instanceof Number || bObj instanceof Number) {
            long b;
            long a = GeExpr.toLong(aObj, env);
            return a >= (b = GeExpr.toLong(bObj, env));
        }
        if (aObj instanceof String || bObj instanceof String) {
            String b;
            String a = GeExpr.toString(aObj, env);
            return a.compareTo(b = GeExpr.toString(bObj, env)) >= 0;
        }
        if (aObj instanceof Comparable) {
            int cmp = ((Comparable)aObj).compareTo(bObj);
            return cmp >= 0;
        }
        if (bObj instanceof Comparable) {
            int cmp = ((Comparable)bObj).compareTo(aObj);
            return cmp <= 0;
        }
        ELException e = new ELException(L.l("can't compare {0} and {1}.", aObj, bObj));
        GeExpr.error(e, env);
        return false;
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.GeExpr(");
        this._left.printCreate(os);
        os.print(", ");
        this._right.printCreate(os);
        os.print(")");
    }

    public boolean equals(Object o) {
        if (!(o instanceof GeExpr)) {
            return false;
        }
        GeExpr expr = (GeExpr)((Object)o);
        return this._left.equals((Object)expr._left) && this._right.equals((Object)expr._right);
    }

    public String toString() {
        return "(" + (Object)((Object)this._left) + " le " + (Object)((Object)this._right) + ")";
    }
}

