/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.Expr;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodExpressionImpl
extends MethodExpression
implements Serializable {
    protected static final Logger log = Logger.getLogger(MethodExpressionImpl.class.getName());
    protected static final L10N L = new L10N(MethodExpressionImpl.class);
    private final String _expressionString;
    private final Expr _expr;
    private final Class _expectedType;
    private final Class[] _expectedArgs;

    public MethodExpressionImpl() {
        this._expressionString = "";
        this._expr = null;
        this._expectedType = null;
        this._expectedArgs = null;
    }

    public MethodExpressionImpl(Expr expr, String expressionString, Class<?> expectedType, Class<?>[] expectedArgs) {
        if (expectedArgs == null) {
            throw new NullPointerException();
        }
        this._expr = expr;
        this._expressionString = expressionString;
        this._expectedType = expectedType;
        this._expectedArgs = expectedArgs;
    }

    public boolean isLiteralText() {
        return this._expr.isLiteralText();
    }

    public String getExpressionString() {
        return this._expressionString;
    }

    public MethodInfo getMethodInfo(ELContext context) throws PropertyNotFoundException, MethodNotFoundException, ELException {
        return this._expr.getMethodInfo(context, this._expectedType, this._expectedArgs);
    }

    public Object invoke(ELContext context, Object[] params) throws PropertyNotFoundException, MethodNotFoundException, ELException {
        if (params == null && this._expectedArgs.length != 0 || params != null && params.length != this._expectedArgs.length) {
            throw new IllegalArgumentException(L.l("'{0}' expected arguments ({1}) do not match actual arguments ({2})", (Object)this._expr.toString(), (Object)this._expectedArgs.length, (Object)(params != null ? params.length : 0)));
        }
        Object value = this._expr.invoke(context, this._expectedArgs, params);
        return Expr.coerceToType(value, this._expectedType);
    }

    public int hashCode() {
        return this._expr.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodExpressionImpl)) {
            return false;
        }
        MethodExpressionImpl expr = (MethodExpressionImpl)o;
        return this._expr.equals((Object)expr._expr);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getExpressionString() + "]";
    }
}

