/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.ArrayExpr;
import com.caucho.el.ArrayResolverExpr;
import com.caucho.el.Expr;
import com.caucho.el.FunctionExpr;
import com.caucho.el.MethodExpr;
import com.caucho.el.StringLiteral;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodInfo;
import javax.el.PropertyNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathExpr
extends Expr {
    private Expr _expr;
    private String _path;

    public PathExpr(Expr expr, String path) {
        this._expr = expr;
        this._path = path;
    }

    @Override
    public Expr createField(String field) {
        Expr arrayExpr = this._expr.createField(new StringLiteral(field));
        return new PathExpr(arrayExpr, this._path + '.' + field);
    }

    @Override
    public Expr createMethod(Expr[] args) {
        ArrayResolverExpr array;
        Expr index;
        if (this._expr instanceof ArrayExpr) {
            ArrayExpr array2 = (ArrayExpr)this._expr;
            Expr index2 = array2.getIndex();
            if (index2 instanceof StringLiteral) {
                StringLiteral string = (StringLiteral)index2;
                return new MethodExpr(array2.getExpr(), string.getValue(), args);
            }
        } else if (this._expr instanceof ArrayResolverExpr && (index = (array = (ArrayResolverExpr)this._expr).getIndex()) instanceof StringLiteral) {
            StringLiteral string = (StringLiteral)index;
            return new MethodExpr(array.getExpr(), string.getValue(), args);
        }
        return new FunctionExpr(this, args);
    }

    @Override
    public Class<?> getType(ELContext env) throws PropertyNotFoundException, ELException {
        Class<?> value = this._expr.getType(env);
        if (env.isPropertyResolved()) {
            return value;
        }
        return env.getELResolver().getType(env, (Object)this._path, null);
    }

    @Override
    public Object getValue(ELContext env) throws ELException {
        Object value = this._expr.getValue(env);
        if (value != null) {
            return value;
        }
        env.setPropertyResolved(false);
        return env.getELResolver().getValue(env, null, (Object)this._path);
    }

    @Override
    public boolean isReadOnly(ELContext env) throws ELException {
        return this._expr.isReadOnly(env);
    }

    @Override
    public void setValue(ELContext env, Object value) throws ELException {
        this._expr.setValue(env, value);
    }

    @Override
    public MethodInfo getMethodInfo(ELContext env, Class<?> retType, Class<?>[] argTypes) throws ELException {
        return this._expr.getMethodInfo(env, retType, argTypes);
    }

    @Override
    public Object invoke(ELContext env, Class<?>[] argTypes, Object[] args) throws ELException {
        return this._expr.invoke(env, argTypes, args);
    }

    @Override
    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.PathExpr(");
        this._expr.printCreate(os);
        os.print(", \"");
        os.print(this._path);
        os.print("\")");
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof PathExpr)) {
            return false;
        }
        PathExpr expr = (PathExpr)((Object)o);
        return this._expr.equals((Object)expr._expr) && this._path.equals(expr._path);
    }

    @Override
    public String toString() {
        return String.valueOf((Object)this._expr);
    }
}

