/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.config.types.Signature;
import com.caucho.el.ELParseException;
import com.caucho.el.Expr;
import com.caucho.el.Marshall;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.el.ELContext;
import javax.el.ELException;

public class StaticMethodExpr
extends Expr {
    private Method _method;
    private Marshall[] _marshall;
    private boolean _isVoid;

    public StaticMethodExpr(Method method) {
        this._method = method;
        this.initMethod();
    }

    public StaticMethodExpr(String signature) {
        try {
            Signature sig = new Signature();
            sig.addText(signature);
            sig.init();
            this._method = sig.getMethod();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        this.initMethod();
    }

    private void initMethod() {
        Class<?>[] param = this._method.getParameterTypes();
        this._marshall = new Marshall[param.length];
        for (int i = 0; i < this._marshall.length; ++i) {
            this._marshall[i] = Marshall.create(param[i]);
        }
        this._isVoid = Void.TYPE.equals(this._method.getReturnType());
    }

    public Object getValue(ELContext env) throws ELException {
        return this._method;
    }

    public Object evalMethod(Expr[] args, ELContext env) throws ELException {
        if (this._marshall.length != args.length) {
            throw new ELParseException(L.l("Arguments to '{0}' do not match expected length {1}.", (Object)this._method.getName(), this._marshall.length));
        }
        try {
            Object[] objs = new Object[args.length];
            for (int i = 0; i < this._marshall.length; ++i) {
                objs[i] = this._marshall[i].marshall(args[i], env);
            }
            if (!this._isVoid) {
                return this._method.invoke(null, objs);
            }
            this._method.invoke(null, objs);
            return null;
        }
        catch (ELException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ELException((Throwable)e);
        }
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.StaticMethodExpr(\"");
        this.printType(os, this._method.getReturnType());
        os.print(" ");
        os.print(this._method.getDeclaringClass().getName());
        os.print(".");
        os.print(this._method.getName());
        os.print("(");
        Class<?>[] parameterTypes = this._method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i != 0) {
                os.print(", ");
            }
            this.printType(os, parameterTypes[i]);
        }
        os.print(")");
        os.print("\")");
    }

    private void printType(WriteStream os, Class cl) throws IOException {
        if (cl.isArray()) {
            this.printType(os, cl.getComponentType());
            os.print("[]");
        } else {
            os.print(cl.getName());
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof StaticMethodExpr)) {
            return false;
        }
        StaticMethodExpr expr = (StaticMethodExpr)((Object)o);
        return this._method.equals(expr._method);
    }

    public String toString() {
        return this._method.getName();
    }
}

