/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.Expr;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.el.ELContext;
import javax.el.ELException;

public class SubExpr
extends Expr {
    private final Expr _left;
    private final Expr _right;

    public SubExpr(Expr left, Expr right) {
        this._left = left;
        this._right = right;
    }

    public boolean isConstant() {
        return this._left.isConstant() && this._right.isConstant();
    }

    public Object getValue(ELContext env) throws ELException {
        Object aObj = this._left.getValue(env);
        Object bObj = this._right.getValue(env);
        if (aObj instanceof BigDecimal || bObj instanceof BigDecimal) {
            BigDecimal a = SubExpr.toBigDecimal(aObj, env);
            BigDecimal b = SubExpr.toBigDecimal(bObj, env);
            return a.subtract(b);
        }
        if (SubExpr.isDouble(aObj)) {
            double b;
            if (bObj instanceof BigInteger) {
                BigDecimal a = SubExpr.toBigDecimal(aObj, env);
                BigDecimal b2 = SubExpr.toBigDecimal(bObj, env);
                return a.subtract(b2);
            }
            double a = SubExpr.toDouble(aObj, env);
            double dValue = a - (b = SubExpr.toDouble(bObj, env));
            return Double.isNaN(dValue) ? new Double(0.0) : new Double(dValue);
        }
        if (SubExpr.isDouble(bObj)) {
            double b;
            if (aObj instanceof BigInteger) {
                BigDecimal a = SubExpr.toBigDecimal(aObj, env);
                BigDecimal b3 = SubExpr.toBigDecimal(bObj, env);
                return a.subtract(b3);
            }
            double a = SubExpr.toDouble(aObj, env);
            double dValue = a - (b = SubExpr.toDouble(bObj, env));
            return Double.isNaN(dValue) ? new Double(0.0) : new Double(dValue);
        }
        if (aObj instanceof BigInteger || bObj instanceof BigInteger) {
            BigInteger a = SubExpr.toBigInteger(aObj, env);
            BigInteger b = SubExpr.toBigInteger(bObj, env);
            return a.subtract(b);
        }
        if (bObj instanceof Double || bObj instanceof Float) {
            double b;
            double a = SubExpr.toDouble(aObj, env);
            double dValue = a - (b = ((Number)bObj).doubleValue());
            return Double.isNaN(dValue) ? new Double(0.0) : new Double(dValue);
        }
        if (aObj instanceof Number) {
            long a = ((Number)aObj).longValue();
            long b = SubExpr.toLong(bObj, env);
            return new Long(a - b);
        }
        if (bObj instanceof Number) {
            long a = SubExpr.toLong(aObj, env);
            long b = ((Number)bObj).longValue();
            return new Long(a - b);
        }
        if (SubExpr.isDoubleString(aObj) || SubExpr.isDoubleString(bObj)) {
            double a = SubExpr.toDouble(aObj, env);
            double b = SubExpr.toDouble(bObj, env);
            return new Double(a - b);
        }
        long a = SubExpr.toLong(aObj, env);
        long b = SubExpr.toLong(bObj, env);
        return new Long(a - b);
    }

    public long evalLong(ELContext env) throws ELException {
        long a = this._left.evalLong(env);
        long b = this._right.evalLong(env);
        return a - b;
    }

    public double evalDouble(ELContext env) throws ELException {
        double a = this._left.evalDouble(env);
        double b = this._right.evalDouble(env);
        return a - b;
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.SubExpr(");
        this._left.printCreate(os);
        os.print(", ");
        this._right.printCreate(os);
        os.print(")");
    }

    public boolean equals(Object o) {
        if (!(o instanceof SubExpr)) {
            return false;
        }
        SubExpr expr = (SubExpr)((Object)o);
        return this._left.equals((Object)expr._left) && this._right.equals((Object)expr._right);
    }

    public String toString() {
        return "(" + (Object)((Object)this._left) + " + " + (Object)((Object)this._right) + ")";
    }
}

