/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.filters;

import com.caucho.filters.FilterWrapperResponseStream;
import com.caucho.log.Log;
import com.caucho.server.connection.AbstractResponseStream;
import com.caucho.server.connection.CauchoResponse;
import com.caucho.server.connection.ResponseWrapper;
import com.caucho.server.connection.ResponseWriter;
import com.caucho.server.connection.ServletOutputStreamImpl;
import com.caucho.vfs.FlushBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class CauchoResponseWrapper
extends ResponseWrapper
implements CauchoResponse {
    private static final Logger log = Log.open(CauchoResponseWrapper.class);
    private FlushBuffer _flushBuffer;
    private final FilterWrapperResponseStream _originalStream;
    protected AbstractResponseStream _stream;
    private ResponseWriter _writer;
    private ServletOutputStreamImpl _os = new ServletOutputStreamImpl();
    private boolean _hasStream;
    private boolean _hasError;

    public CauchoResponseWrapper() {
        this._writer = new ResponseWriter();
        this._originalStream = new FilterWrapperResponseStream();
    }

    public CauchoResponseWrapper(HttpServletResponse response) {
        this();
        this.init(response);
    }

    public void init(HttpServletResponse response) {
        this.setResponse(response);
        this._stream = this._originalStream;
        this._os.init((OutputStream)((Object)this._originalStream));
        this._writer.init(this._originalStream);
        this._hasStream = false;
        this._hasError = false;
        this._originalStream.init(this);
        this._originalStream.start();
    }

    public void close() throws IOException {
        if (this._stream != null) {
            this._stream.close();
        } else {
            this._originalStream.close();
        }
    }

    public ServletResponse getResponse() {
        return this._response;
    }

    public void setContentType(String value) {
        this._response.setContentType(value);
        try {
            this._stream.setEncoding(this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void setResponseStream(AbstractResponseStream stream) {
        this._stream = stream;
        this._os.init((OutputStream)((Object)stream));
        this._writer.init(stream);
    }

    public AbstractResponseStream getResponseStream() {
        return this._stream;
    }

    public boolean isCauchoResponseStream() {
        return true;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this._os;
    }

    public PrintWriter getWriter() throws IOException {
        return this._writer;
    }

    protected OutputStream getStream() throws IOException {
        return this._response.getOutputStream();
    }

    public void setFlushBuffer(FlushBuffer flushBuffer) {
        this._flushBuffer = flushBuffer;
    }

    public FlushBuffer getFlushBuffer() {
        return this._flushBuffer;
    }

    public void flushBuffer() throws IOException {
        if (this._flushBuffer != null) {
            this._flushBuffer.flushBuffer();
        }
        this._stream.flushBuffer();
    }

    public void reset() {
        super.reset();
        this.resetBuffer();
    }

    public void resetBuffer() {
        if (this._stream != null) {
            this._stream.clearBuffer();
        }
        this._response.resetBuffer();
    }

    public void clearBuffer() {
        this.resetBuffer();
    }

    public void setLocale(Locale locale) {
        this._response.setLocale(locale);
        try {
            this._stream.setLocale(this._response.getLocale());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String getHeader(String key) {
        return null;
    }

    public boolean disableHeaders(boolean disable) {
        return false;
    }

    public void setFooter(String key, String value) {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).setFooter(key, value);
        }
    }

    public void addFooter(String key, String value) {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).addFooter(key, value);
        }
    }

    public int getRemaining() {
        return this._stream.getRemaining();
    }

    public void setForbidForward(boolean forbid) {
    }

    public boolean getForbidForward() {
        return false;
    }

    public void setHasError(boolean hasError) {
        this._hasError = hasError;
    }

    public boolean hasError() {
        return this._hasError;
    }

    public void killCache() {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).killCache();
        }
    }

    public void setSessionId(String id) {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).setSessionId(id);
        }
    }

    public void setPrivateCache(boolean isPrivate) {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).setPrivateCache(isPrivate);
        }
    }

    public void setNoCache(boolean isPrivate) {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).setNoCache(isPrivate);
        }
    }
}

